/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.catalog;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.catalog.spi.Dataset;
import org.eclipse.edc.catalog.spi.DatasetResolver;
import org.eclipse.edc.connector.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.agent.ParticipantAgent;
import org.eclipse.edc.spi.agent.ParticipantAgentService;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.jetbrains.annotations.NotNull;

public class CatalogProtocolServiceImpl
implements CatalogProtocolService {
    private static final String PARTICIPANT_ID_PROPERTY_KEY = "participantId";
    private final DatasetResolver datasetResolver;
    private final ParticipantAgentService participantAgentService;
    private final DataServiceRegistry dataServiceRegistry;
    private final String participantId;

    public CatalogProtocolServiceImpl(DatasetResolver datasetResolver, ParticipantAgentService participantAgentService, DataServiceRegistry dataServiceRegistry, String participantId) {
        this.datasetResolver = datasetResolver;
        this.participantAgentService = participantAgentService;
        this.dataServiceRegistry = dataServiceRegistry;
        this.participantId = participantId;
    }

    @NotNull
    public ServiceResult<Catalog> getCatalog(CatalogRequestMessage message, ClaimToken claimToken) {
        ParticipantAgent agent = this.participantAgentService.createFor(claimToken);
        try (Stream datasets = this.datasetResolver.query(agent, message.getQuerySpec());){
            List dataServices = this.dataServiceRegistry.getDataServices();
            Catalog catalog = Catalog.Builder.newInstance().dataServices(dataServices).datasets(datasets.collect(Collectors.toList())).property("https://w3id.org/edc/v0.0.1/ns/participantId", (Object)this.participantId).build();
            ServiceResult serviceResult = ServiceResult.success((Object)catalog);
            return serviceResult;
        }
    }

    @NotNull
    public ServiceResult<Dataset> getDataset(String datasetId, ClaimToken claimToken) {
        ParticipantAgent agent = this.participantAgentService.createFor(claimToken);
        Dataset dataset = this.datasetResolver.getById(agent, datasetId);
        if (dataset == null) {
            return ServiceResult.notFound((String)String.format("Dataset %s does not exist", datasetId));
        }
        return ServiceResult.success((Object)dataset);
    }
}

