/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.asset;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.edc.connector.asset.spi.observe.AssetObservable;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.service.asset.AssetQueryValidator;
import org.eclipse.edc.connector.service.query.QueryValidator;
import org.eclipse.edc.connector.spi.asset.AssetService;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.asset.AssetIndex;
import org.eclipse.edc.spi.dataaddress.DataAddressValidator;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.asset.Asset;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class AssetServiceImpl
implements AssetService {
    private static final String ASSET_ID_QUERY = "contractAgreement.assetId";
    private static final String DUPLICATED_KEYS_MESSAGE = "Duplicate keys in properties and private properties are not allowed";
    private final AssetIndex index;
    private final ContractNegotiationStore contractNegotiationStore;
    private final TransactionContext transactionContext;
    private final AssetObservable observable;
    private final DataAddressValidator dataAddressValidator;
    private final QueryValidator queryValidator;

    public AssetServiceImpl(AssetIndex index, ContractNegotiationStore contractNegotiationStore, TransactionContext transactionContext, AssetObservable observable, DataAddressValidator dataAddressValidator) {
        this.index = index;
        this.contractNegotiationStore = contractNegotiationStore;
        this.transactionContext = transactionContext;
        this.observable = observable;
        this.dataAddressValidator = dataAddressValidator;
        this.queryValidator = new AssetQueryValidator();
    }

    public Asset findById(String assetId) {
        return (Asset)this.transactionContext.execute(() -> this.index.findById(assetId));
    }

    public ServiceResult<Stream<Asset>> query(QuerySpec query) {
        Result<Void> result = this.queryValidator.validate(query);
        if (result.failed()) {
            return ServiceResult.badRequest((List)result.getFailureMessages());
        }
        return ServiceResult.success((Object)((Stream)this.transactionContext.execute(() -> this.index.queryAssets(query))));
    }

    public ServiceResult<Asset> create(Asset asset, DataAddress dataAddress) {
        return this.create(asset.toBuilder().dataAddress(dataAddress).build());
    }

    public ServiceResult<Asset> create(Asset asset) {
        if (asset.hasDuplicatePropertyKeys()) {
            return ServiceResult.badRequest((String[])new String[]{DUPLICATED_KEYS_MESSAGE});
        }
        Result validDataAddress = this.dataAddressValidator.validate(asset.getDataAddress());
        if (validDataAddress.failed()) {
            return ServiceResult.badRequest((List)validDataAddress.getFailureMessages());
        }
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult createResult = this.index.create(asset);
            if (createResult.succeeded()) {
                this.observable.invokeForEach(l -> l.created(asset));
                return ServiceResult.success((Object)asset);
            }
            return ServiceResult.fromFailure((StoreResult)createResult);
        });
    }

    public ServiceResult<Asset> delete(String assetId) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            QuerySpec query = QuerySpec.Builder.newInstance().filter(List.of(new Criterion((Object)ASSET_ID_QUERY, "=", (Object)assetId))).build();
            try (Stream negotiationsOnAsset = this.contractNegotiationStore.queryNegotiations(query);){
                if (negotiationsOnAsset.findAny().isPresent()) {
                    ServiceResult serviceResult = ServiceResult.conflict((String)String.format("Asset %s cannot be deleted as it is referenced by at least one contract agreement", assetId));
                    return serviceResult;
                }
            }
            StoreResult deleted = this.index.deleteById(assetId);
            deleted.onSuccess(a -> this.observable.invokeForEach(l -> l.deleted(a)));
            return ServiceResult.from((StoreResult)deleted);
        });
    }

    public ServiceResult<Asset> update(Asset asset) {
        if (asset.hasDuplicatePropertyKeys()) {
            return ServiceResult.badRequest((String[])new String[]{DUPLICATED_KEYS_MESSAGE});
        }
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult updatedAsset = this.index.updateAsset(asset);
            updatedAsset.onSuccess(a -> this.observable.invokeForEach(l -> l.updated(a)));
            return ServiceResult.from((StoreResult)updatedAsset);
        });
    }

    public ServiceResult<DataAddress> update(String assetId, DataAddress dataAddress) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult result = this.index.updateDataAddress(assetId, dataAddress);
            result.onSuccess(da -> this.observable.invokeForEach(l -> l.updated(this.findById(assetId))));
            return ServiceResult.from((StoreResult)result);
        });
    }
}

