/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.asset;

import java.time.Clock;
import org.eclipse.edc.connector.asset.spi.event.AssetCreated;
import org.eclipse.edc.connector.asset.spi.event.AssetDeleted;
import org.eclipse.edc.connector.asset.spi.event.AssetEvent;
import org.eclipse.edc.connector.asset.spi.event.AssetUpdated;
import org.eclipse.edc.connector.asset.spi.observe.AssetListener;
import org.eclipse.edc.spi.event.Event;
import org.eclipse.edc.spi.event.EventEnvelope;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.types.domain.asset.Asset;

public class AssetEventListener
implements AssetListener {
    private final Clock clock;
    private final EventRouter eventRouter;

    public AssetEventListener(Clock clock, EventRouter eventRouter) {
        this.clock = clock;
        this.eventRouter = eventRouter;
    }

    public void created(Asset asset) {
        AssetCreated event = (AssetCreated)((AssetCreated.Builder)AssetCreated.Builder.newInstance().assetId(asset.getId())).build();
        this.publish((AssetEvent)event);
    }

    public void deleted(Asset asset) {
        AssetDeleted event = (AssetDeleted)((AssetDeleted.Builder)AssetDeleted.Builder.newInstance().assetId(asset.getId())).build();
        this.publish((AssetEvent)event);
    }

    public void updated(Asset asset) {
        AssetUpdated event = (AssetUpdated)((AssetUpdated.Builder)AssetUpdated.Builder.newInstance().assetId(asset.getId())).build();
        this.publish((AssetEvent)event);
    }

    private void publish(AssetEvent event) {
        EventEnvelope envelope = EventEnvelope.Builder.newInstance().payload((Event)event).at(this.clock.millis()).build();
        this.eventRouter.publish(envelope);
    }
}

