/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service;

import java.time.Clock;
import org.eclipse.edc.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.catalog.spi.DatasetResolver;
import org.eclipse.edc.connector.asset.spi.observe.AssetObservable;
import org.eclipse.edc.connector.asset.spi.observe.AssetObservableImpl;
import org.eclipse.edc.connector.contract.spi.definition.observe.ContractDefinitionObservable;
import org.eclipse.edc.connector.contract.spi.definition.observe.ContractDefinitionObservableImpl;
import org.eclipse.edc.connector.contract.spi.negotiation.ConsumerContractNegotiationManager;
import org.eclipse.edc.connector.contract.spi.negotiation.observe.ContractNegotiationObservable;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.contract.spi.offer.store.ContractDefinitionStore;
import org.eclipse.edc.connector.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.policy.spi.observe.PolicyDefinitionObservable;
import org.eclipse.edc.connector.policy.spi.observe.PolicyDefinitionObservableImpl;
import org.eclipse.edc.connector.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.connector.service.asset.AssetEventListener;
import org.eclipse.edc.connector.service.asset.AssetServiceImpl;
import org.eclipse.edc.connector.service.catalog.CatalogProtocolServiceImpl;
import org.eclipse.edc.connector.service.catalog.CatalogServiceImpl;
import org.eclipse.edc.connector.service.contractagreement.ContractAgreementServiceImpl;
import org.eclipse.edc.connector.service.contractdefinition.ContractDefinitionEventListener;
import org.eclipse.edc.connector.service.contractdefinition.ContractDefinitionServiceImpl;
import org.eclipse.edc.connector.service.contractnegotiation.ContractNegotiationProtocolServiceImpl;
import org.eclipse.edc.connector.service.contractnegotiation.ContractNegotiationServiceImpl;
import org.eclipse.edc.connector.service.dataaddress.DataAddressValidatorImpl;
import org.eclipse.edc.connector.service.policydefinition.PolicyDefinitionEventListener;
import org.eclipse.edc.connector.service.policydefinition.PolicyDefinitionServiceImpl;
import org.eclipse.edc.connector.service.transferprocess.TransferProcessProtocolServiceImpl;
import org.eclipse.edc.connector.service.transferprocess.TransferProcessServiceImpl;
import org.eclipse.edc.connector.spi.asset.AssetService;
import org.eclipse.edc.connector.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.connector.spi.catalog.CatalogService;
import org.eclipse.edc.connector.spi.contractagreement.ContractAgreementService;
import org.eclipse.edc.connector.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.connector.spi.policydefinition.PolicyDefinitionService;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.transfer.spi.TransferProcessManager;
import org.eclipse.edc.connector.transfer.spi.observe.TransferProcessObservable;
import org.eclipse.edc.connector.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.agent.ParticipantAgentService;
import org.eclipse.edc.spi.asset.AssetIndex;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.dataaddress.DataAddressValidator;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Extension(value="Control Plane Services")
public class ControlPlaneServicesExtension
implements ServiceExtension {
    public static final String NAME = "Control Plane Services";
    private final DataAddressValidator dataAddressValidator = new DataAddressValidatorImpl();
    @Inject
    private Clock clock;
    @Inject
    private Monitor monitor;
    @Inject
    private EventRouter eventRouter;
    @Inject
    private RemoteMessageDispatcherRegistry dispatcher;
    @Inject
    private AssetIndex assetIndex;
    @Inject
    private ContractDefinitionStore contractDefinitionStore;
    @Inject
    private ContractNegotiationStore contractNegotiationStore;
    @Inject
    private ConsumerContractNegotiationManager consumerContractNegotiationManager;
    @Inject
    private PolicyDefinitionStore policyDefinitionStore;
    @Inject
    private TransferProcessStore transferProcessStore;
    @Inject
    private TransferProcessManager transferProcessManager;
    @Inject
    private TransactionContext transactionContext;
    @Inject
    private ContractValidationService contractValidationService;
    @Inject
    private ContractNegotiationObservable contractNegotiationObservable;
    @Inject
    private TransferProcessObservable transferProcessObservable;
    @Inject
    private Telemetry telemetry;
    @Inject
    private ParticipantAgentService participantAgentService;
    @Inject
    private DataServiceRegistry dataServiceRegistry;
    @Inject
    private DatasetResolver datasetResolver;
    @Inject
    private CommandHandlerRegistry commandHandlerRegistry;

    public String name() {
        return NAME;
    }

    @Provider
    public AssetService assetService() {
        AssetObservableImpl assetObservable = new AssetObservableImpl();
        assetObservable.registerListener((Object)new AssetEventListener(this.clock, this.eventRouter));
        return new AssetServiceImpl(this.assetIndex, this.contractNegotiationStore, this.transactionContext, (AssetObservable)assetObservable, this.dataAddressValidator);
    }

    @Provider
    public CatalogService catalogService() {
        return new CatalogServiceImpl(this.dispatcher);
    }

    @Provider
    public CatalogProtocolService catalogProtocolService(ServiceExtensionContext context) {
        return new CatalogProtocolServiceImpl(this.datasetResolver, this.participantAgentService, this.dataServiceRegistry, context.getParticipantId());
    }

    @Provider
    public ContractAgreementService contractAgreementService() {
        return new ContractAgreementServiceImpl(this.contractNegotiationStore, this.transactionContext);
    }

    @Provider
    public ContractDefinitionService contractDefinitionService() {
        ContractDefinitionObservableImpl contractDefinitionObservable = new ContractDefinitionObservableImpl();
        contractDefinitionObservable.registerListener((Object)new ContractDefinitionEventListener(this.clock, this.eventRouter));
        return new ContractDefinitionServiceImpl(this.contractDefinitionStore, this.transactionContext, (ContractDefinitionObservable)contractDefinitionObservable);
    }

    @Provider
    public ContractNegotiationService contractNegotiationService() {
        return new ContractNegotiationServiceImpl(this.contractNegotiationStore, this.consumerContractNegotiationManager, this.transactionContext, this.commandHandlerRegistry);
    }

    @Provider
    public ContractNegotiationProtocolService contractNegotiationProtocolService() {
        return new ContractNegotiationProtocolServiceImpl(this.contractNegotiationStore, this.transactionContext, this.contractValidationService, this.contractNegotiationObservable, this.monitor, this.telemetry);
    }

    @Provider
    public PolicyDefinitionService policyDefinitionService() {
        PolicyDefinitionObservableImpl policyDefinitionObservable = new PolicyDefinitionObservableImpl();
        policyDefinitionObservable.registerListener((Object)new PolicyDefinitionEventListener(this.clock, this.eventRouter));
        return new PolicyDefinitionServiceImpl(this.transactionContext, this.policyDefinitionStore, this.contractDefinitionStore, (PolicyDefinitionObservable)policyDefinitionObservable);
    }

    @Provider
    public TransferProcessService transferProcessService() {
        return new TransferProcessServiceImpl(this.transferProcessStore, this.transferProcessManager, this.transactionContext, this.dataAddressValidator, this.commandHandlerRegistry);
    }

    @Provider
    public TransferProcessProtocolService transferProcessProtocolService() {
        return new TransferProcessProtocolServiceImpl(this.transferProcessStore, this.transactionContext, this.contractNegotiationStore, this.contractValidationService, this.dataAddressValidator, this.transferProcessObservable, this.clock, this.monitor, this.telemetry);
    }
}

