/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.transferprocess;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidator;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.controlplane.transfer.spi.TransferProcessManager;
import org.eclipse.edc.connector.controlplane.transfer.spi.flow.TransferTypeParser;
import org.eclipse.edc.connector.controlplane.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.DeprovisionedResource;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.ProvisionResponse;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcessStates;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferRequest;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.AddProvisionedResourceCommand;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.CompleteProvisionCommand;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.CompleteTransferCommand;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.DeprovisionCompleteCommand;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.DeprovisionRequest;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.ResumeTransferCommand;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.SuspendTransferCommand;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.TerminateTransferCommand;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.command.EntityCommand;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.transfer.FlowType;
import org.eclipse.edc.spi.types.domain.transfer.TransferType;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferProcessServiceImpl
implements TransferProcessService {
    private final TransferProcessStore transferProcessStore;
    private final TransferProcessManager manager;
    private final TransactionContext transactionContext;
    private final QueryValidator queryValidator;
    private final DataAddressValidatorRegistry dataAddressValidator;
    private final CommandHandlerRegistry commandHandlerRegistry;
    private final TransferTypeParser transferTypeParser;
    private final ContractNegotiationStore contractNegotiationStore;

    public TransferProcessServiceImpl(TransferProcessStore transferProcessStore, TransferProcessManager manager, TransactionContext transactionContext, DataAddressValidatorRegistry dataAddressValidator, CommandHandlerRegistry commandHandlerRegistry, TransferTypeParser transferTypeParser, ContractNegotiationStore contractNegotiationStore, QueryValidator queryValidator) {
        this.transferProcessStore = transferProcessStore;
        this.manager = manager;
        this.transactionContext = transactionContext;
        this.dataAddressValidator = dataAddressValidator;
        this.commandHandlerRegistry = commandHandlerRegistry;
        this.transferTypeParser = transferTypeParser;
        this.contractNegotiationStore = contractNegotiationStore;
        this.queryValidator = queryValidator;
    }

    @Nullable
    public TransferProcess findById(String transferProcessId) {
        return (TransferProcess)this.transactionContext.execute(() -> (TransferProcess)this.transferProcessStore.findById(transferProcessId));
    }

    public ServiceResult<List<TransferProcess>> search(QuerySpec query) {
        return (ServiceResult)this.queryValidator.validate(query).flatMap(validation -> validation.failed() ? ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", validation.getFailureDetail())}) : ServiceResult.success(this.queryTransferProcesses(query)));
    }

    @Nullable
    public String getState(String transferProcessId) {
        return (String)this.transactionContext.execute(() -> {
            TransferProcess process = (TransferProcess)this.transferProcessStore.findById(transferProcessId);
            return Optional.ofNullable(process).map(p -> TransferProcessStates.from((int)p.getState()).name()).orElse(null);
        });
    }

    @NotNull
    public ServiceResult<Void> complete(String transferProcessId) {
        return this.execute((EntityCommand)new CompleteTransferCommand(transferProcessId));
    }

    @NotNull
    public ServiceResult<Void> terminate(TerminateTransferCommand command) {
        return this.execute((EntityCommand)command);
    }

    @NotNull
    public ServiceResult<Void> suspend(SuspendTransferCommand command) {
        return this.execute((EntityCommand)command);
    }

    @NotNull
    public ServiceResult<Void> resume(ResumeTransferCommand command) {
        return this.execute((EntityCommand)command);
    }

    @NotNull
    public ServiceResult<Void> deprovision(String transferProcessId) {
        return this.execute((EntityCommand)new DeprovisionRequest(transferProcessId));
    }

    @NotNull
    public ServiceResult<TransferProcess> initiateTransfer(TransferRequest request) {
        Result transferTypeParse = this.transferTypeParser.parse(request.getTransferType());
        if (transferTypeParse.failed()) {
            return ServiceResult.badRequest((String[])new String[]{"Property transferType not valid: " + transferTypeParse.getFailureDetail()});
        }
        ContractAgreement agreement = this.contractNegotiationStore.findContractAgreement(request.getContractId());
        if (agreement == null) {
            return ServiceResult.badRequest((String[])new String[]{"Contract agreement with id %s not found".formatted(request.getContractId())});
        }
        FlowType flowType = ((TransferType)transferTypeParse.getContent()).flowType();
        if (flowType == FlowType.PUSH) {
            if (request.getDataDestination() == null) {
                return ServiceResult.badRequest((String[])new String[]{"For PUSH transfers dataDestination must be defined"});
            }
            ValidationResult validDestination = this.dataAddressValidator.validateDestination(request.getDataDestination());
            if (validDestination.failed()) {
                return ServiceResult.badRequest((List)validDestination.getFailureMessages());
            }
        }
        return (ServiceResult)this.transactionContext.execute(() -> {
            StatusResult transferInitiateResult = this.manager.initiateConsumerRequest(request);
            return Optional.ofNullable(transferInitiateResult).filter(AbstractResult::succeeded).map(AbstractResult::getContent).map(ServiceResult::success).orElse(ServiceResult.conflict((String)"Request couldn't be initialised."));
        });
    }

    public ServiceResult<Void> completeProvision(CompleteProvisionCommand command) {
        return this.execute((EntityCommand)command);
    }

    public ServiceResult<Void> completeDeprovision(String transferProcessId, DeprovisionedResource resource) {
        return this.execute((EntityCommand)new DeprovisionCompleteCommand(transferProcessId, resource));
    }

    public ServiceResult<Void> addProvisionedResource(String transferProcessId, ProvisionResponse response) {
        return this.execute((EntityCommand)new AddProvisionedResourceCommand(transferProcessId, response));
    }

    private List<TransferProcess> queryTransferProcesses(QuerySpec query) {
        return (List)this.transactionContext.execute(() -> {
            try (Stream stream = this.transferProcessStore.findAll(query);){
                List list = stream.toList();
                return list;
            }
        });
    }

    private ServiceResult<Void> execute(EntityCommand command) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute(command).flatMap(ServiceResult::from));
    }
}

