/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.secret;

import java.util.Optional;
import org.eclipse.edc.connector.secret.spi.observe.SecretObservable;
import org.eclipse.edc.connector.spi.service.SecretService;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.domain.secret.Secret;

public class SecretServiceImpl
implements SecretService {
    private final Vault vault;
    private final SecretObservable observable;

    public SecretServiceImpl(Vault vault, SecretObservable observable) {
        this.vault = vault;
        this.observable = observable;
    }

    public Secret findById(String secretId) {
        return Optional.ofNullable(this.vault.resolveSecret(secretId)).map(secretValue -> ((Secret.Builder)Secret.Builder.newInstance().value(secretValue).id(secretId)).build()).orElse(null);
    }

    public ServiceResult<Secret> create(Secret secret) {
        Secret existing = this.findById(secret.getId());
        if (existing != null) {
            return ServiceResult.conflict((String)("Secret " + secret.getId() + " already exist"));
        }
        return (ServiceResult)((Result)this.vault.storeSecret(secret.getId(), secret.getValue()).onSuccess(unused -> this.observable.invokeForEach(l -> l.created(secret)))).map(unused -> ServiceResult.success((Object)secret)).orElse(failure -> ServiceResult.badRequest((String[])new String[]{failure.getFailureDetail()}));
    }

    public ServiceResult<Secret> delete(String secretKey) {
        Secret existing = this.findById(secretKey);
        if (existing == null) {
            return ServiceResult.notFound((String)("Secret " + secretKey + " not found"));
        }
        return (ServiceResult)((Result)this.vault.deleteSecret(secretKey).onSuccess(unused -> this.observable.invokeForEach(l -> l.deleted(existing)))).map(unused -> ServiceResult.success((Object)existing)).orElse(failure -> ServiceResult.badRequest((String[])new String[]{failure.getFailureDetail()}));
    }

    public ServiceResult<Secret> update(Secret secret) {
        Secret existing = this.findById(secret.getId());
        if (existing == null) {
            return ServiceResult.notFound((String)("Secret " + secret.getId() + " not found"));
        }
        return (ServiceResult)((Result)this.vault.storeSecret(secret.getId(), secret.getValue()).onSuccess(unused -> this.observable.invokeForEach(l -> l.updated(secret)))).map(unused -> ServiceResult.success((Object)secret)).orElse(failure -> ServiceResult.badRequest((String[])new String[]{failure.getFailureDetail()}));
    }
}

