/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.secret;

import java.time.Clock;
import org.eclipse.edc.connector.secret.spi.event.SecretCreated;
import org.eclipse.edc.connector.secret.spi.event.SecretDeleted;
import org.eclipse.edc.connector.secret.spi.event.SecretEvent;
import org.eclipse.edc.connector.secret.spi.event.SecretUpdated;
import org.eclipse.edc.connector.secret.spi.observe.SecretListener;
import org.eclipse.edc.spi.event.Event;
import org.eclipse.edc.spi.event.EventEnvelope;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.types.domain.secret.Secret;

public class SecretEventListener
implements SecretListener {
    private final Clock clock;
    private final EventRouter eventRouter;

    public SecretEventListener(Clock clock, EventRouter eventRouter) {
        this.clock = clock;
        this.eventRouter = eventRouter;
    }

    public void created(Secret secret) {
        SecretCreated event = (SecretCreated)((SecretCreated.Builder)SecretCreated.Builder.newInstance().secretId(secret.getId())).build();
        this.publish((SecretEvent)event);
    }

    public void deleted(Secret secret) {
        SecretDeleted event = (SecretDeleted)((SecretDeleted.Builder)SecretDeleted.Builder.newInstance().secretId(secret.getId())).build();
        this.publish((SecretEvent)event);
    }

    public void updated(Secret secret) {
        SecretUpdated event = (SecretUpdated)((SecretUpdated.Builder)SecretUpdated.Builder.newInstance().secretId(secret.getId())).build();
        this.publish((SecretEvent)event);
    }

    private void publish(SecretEvent event) {
        EventEnvelope envelope = EventEnvelope.Builder.newInstance().payload((Event)event).at(this.clock.millis()).build();
        this.eventRouter.publish(envelope);
    }
}

