/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.query;

import java.util.List;
import java.util.Map;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.controlplane.policy.spi.PolicyDefinition;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidator;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.ProvisionedContentResource;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.ProvisionedDataAddressResource;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.ProvisionedDataDestinationResource;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.ProvisionedResource;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.policy.model.AndConstraint;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.Constraint;
import org.eclipse.edc.policy.model.Expression;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.policy.model.MultiplicityConstraint;
import org.eclipse.edc.policy.model.OrConstraint;
import org.eclipse.edc.policy.model.XoneConstraint;

public final class QueryValidators {
    public static QueryValidator contractAgreement() {
        return new QueryValidator(ContractAgreement.class);
    }

    public static QueryValidator contractDefinition() {
        return new QueryValidator(ContractDefinition.class);
    }

    public static QueryValidator contractNegotiation() {
        return new QueryValidator(ContractNegotiation.class);
    }

    public static QueryValidator policyDefinition() {
        return new QueryValidator(PolicyDefinition.class, QueryValidators.policySubtypeMap());
    }

    public static QueryValidator transferProcess() {
        return new QueryValidator(TransferProcess.class, QueryValidators.transferProcessSubtypeMap());
    }

    private static Map<Class<?>, List<Class<?>>> policySubtypeMap() {
        return Map.of(Constraint.class, List.of(MultiplicityConstraint.class, AtomicConstraint.class), MultiplicityConstraint.class, List.of(AndConstraint.class, OrConstraint.class, XoneConstraint.class), Expression.class, List.of(LiteralExpression.class));
    }

    private static Map<Class<?>, List<Class<?>>> transferProcessSubtypeMap() {
        return Map.of(ProvisionedResource.class, List.of(ProvisionedDataAddressResource.class), ProvisionedDataAddressResource.class, List.of(ProvisionedDataDestinationResource.class, ProvisionedContentResource.class));
    }
}

