/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.query;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.util.reflection.ReflectionUtil;

public class QueryValidator {
    private final Class<?> canonicalType;
    private final Map<Class<?>, List<Class<?>>> subtypeMap;

    public QueryValidator(Class<?> canonicalType, Map<Class<?>, List<Class<?>>> typeHierarchyMap) {
        this.canonicalType = canonicalType;
        this.subtypeMap = typeHierarchyMap;
    }

    public QueryValidator(Class<?> canonicalType) {
        this(canonicalType, Collections.emptyMap());
    }

    public Result<Void> validate(QuerySpec query) {
        return query.getFilterExpression().stream().map(Criterion::getOperandLeft).map(Object::toString).map(this::isValid).reduce(Result::merge).orElse(Result.success());
    }

    protected Result<Void> isValid(String path) {
        if (path.endsWith(".") || path.startsWith(".")) {
            return Result.failure((String)"Invalid path expression");
        }
        String[] pathTokens = path.split("\\.");
        Class<?> type = this.canonicalType;
        for (String token : pathTokens) {
            if (type == Map.class) {
                Pattern pattern = Pattern.compile("^[0-9A-Za-z.':/@]*$");
                Matcher matcher = pattern.matcher(path);
                return matcher.find() ? Result.success() : Result.failure((String)"Querying Map types is not yet supported");
            }
            Field field = this.getFieldIncludingSubtypes(type, token);
            if (field != null) {
                type = field.getType();
                if (!Collection.class.isAssignableFrom(type)) continue;
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                type = (Class<?>)genericType.getActualTypeArguments()[0];
                continue;
            }
            return Result.failure((String)String.format("Field %s not found on type %s", token, type));
        }
        return Result.success();
    }

    private Field getFieldIncludingSubtypes(Class<?> type, String token) {
        List<Class<?>> subTypes;
        Field field = ReflectionUtil.getFieldRecursive(type, (String)token);
        if (field == null && (subTypes = this.subtypeMap.get(type)) != null) {
            return subTypes.stream().map(st -> this.getFieldIncludingSubtypes((Class<?>)st, token)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return field;
    }
}

