/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.protocol;

import java.util.Collection;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolTokenValidator;
import org.eclipse.edc.participant.spi.ParticipantAgent;
import org.eclipse.edc.participant.spi.ParticipantAgentService;
import org.eclipse.edc.policy.context.request.spi.RequestPolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.iam.RequestContext;
import org.eclipse.edc.spi.iam.RequestScope;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.iam.VerificationContext;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;

public class ProtocolTokenValidatorImpl
implements ProtocolTokenValidator {
    private final IdentityService identityService;
    private final PolicyEngine policyEngine;
    private final ParticipantAgentService agentService;
    private final Monitor monitor;

    public ProtocolTokenValidatorImpl(IdentityService identityService, PolicyEngine policyEngine, Monitor monitor, ParticipantAgentService agentService) {
        this.identityService = identityService;
        this.monitor = monitor;
        this.policyEngine = policyEngine;
        this.agentService = agentService;
    }

    public ServiceResult<ParticipantAgent> verify(TokenRepresentation tokenRepresentation, RequestPolicyContext.Provider policyContextProvider, Policy policy, RemoteMessage message) {
        RequestScope.Builder requestScopeBuilder = RequestScope.Builder.newInstance();
        RequestContext requestContext = RequestContext.Builder.newInstance().message(message).direction(RequestContext.Direction.Ingress).build();
        RequestPolicyContext policyContext = policyContextProvider.instantiate(requestContext, requestScopeBuilder);
        this.policyEngine.evaluate(policy, (PolicyContext)policyContext);
        VerificationContext verificationContext = VerificationContext.Builder.newInstance().policy(policy).scopes((Collection)policyContext.requestScopeBuilder().build().getScopes()).build();
        Result tokenValidation = this.identityService.verifyJwtToken(tokenRepresentation, verificationContext);
        if (tokenValidation.failed()) {
            this.monitor.debug(() -> "Unauthorized: %s".formatted(tokenValidation.getFailureDetail()), new Throwable[0]);
            return ServiceResult.unauthorized((String)"Unauthorized");
        }
        ClaimToken claimToken = (ClaimToken)tokenValidation.getContent();
        ParticipantAgent participantAgent = this.agentService.createFor(claimToken);
        return ServiceResult.success((Object)participantAgent);
    }
}

