/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.policydefinition;

import java.time.Clock;
import org.eclipse.edc.connector.controlplane.policy.spi.PolicyDefinition;
import org.eclipse.edc.connector.controlplane.policy.spi.event.PolicyDefinitionCreated;
import org.eclipse.edc.connector.controlplane.policy.spi.event.PolicyDefinitionDeleted;
import org.eclipse.edc.connector.controlplane.policy.spi.event.PolicyDefinitionEvent;
import org.eclipse.edc.connector.controlplane.policy.spi.event.PolicyDefinitionUpdated;
import org.eclipse.edc.connector.controlplane.policy.spi.observe.PolicyDefinitionListener;
import org.eclipse.edc.spi.event.Event;
import org.eclipse.edc.spi.event.EventEnvelope;
import org.eclipse.edc.spi.event.EventRouter;

public class PolicyDefinitionEventListener
implements PolicyDefinitionListener {
    private final Clock clock;
    private final EventRouter eventRouter;

    public PolicyDefinitionEventListener(Clock clock, EventRouter eventRouter) {
        this.clock = clock;
        this.eventRouter = eventRouter;
    }

    public void created(PolicyDefinition policyDefinition) {
        PolicyDefinitionCreated event = (PolicyDefinitionCreated)((PolicyDefinitionCreated.Builder)PolicyDefinitionCreated.Builder.newInstance().policyDefinitionId(policyDefinition.getId())).build();
        this.publish((PolicyDefinitionEvent)event);
    }

    public void deleted(PolicyDefinition policyDefinition) {
        PolicyDefinitionDeleted event = (PolicyDefinitionDeleted)((PolicyDefinitionDeleted.Builder)PolicyDefinitionDeleted.Builder.newInstance().policyDefinitionId(policyDefinition.getId())).build();
        this.publish((PolicyDefinitionEvent)event);
    }

    public void updated(PolicyDefinition policyDefinition) {
        PolicyDefinitionUpdated event = (PolicyDefinitionUpdated)((PolicyDefinitionUpdated.Builder)PolicyDefinitionUpdated.Builder.newInstance().policyDefinitionId(policyDefinition.getId())).build();
        this.publish((PolicyDefinitionEvent)event);
    }

    private void publish(PolicyDefinitionEvent event) {
        EventEnvelope envelope = EventEnvelope.Builder.newInstance().payload((Event)event).at(this.clock.millis()).build();
        this.eventRouter.publish(envelope);
    }
}

