/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.contractnegotiation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ConsumerContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.command.TerminateNegotiationCommand;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidator;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.command.EntityCommand;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class ContractNegotiationServiceImpl
implements ContractNegotiationService {
    private final ContractNegotiationStore store;
    private final ConsumerContractNegotiationManager consumerManager;
    private final TransactionContext transactionContext;
    private final CommandHandlerRegistry commandHandlerRegistry;
    private final QueryValidator queryValidator;

    public ContractNegotiationServiceImpl(ContractNegotiationStore store, ConsumerContractNegotiationManager consumerManager, TransactionContext transactionContext, CommandHandlerRegistry commandHandlerRegistry, QueryValidator queryValidator) {
        this.store = store;
        this.consumerManager = consumerManager;
        this.transactionContext = transactionContext;
        this.commandHandlerRegistry = commandHandlerRegistry;
        this.queryValidator = queryValidator;
    }

    public ContractNegotiation findbyId(String contractNegotiationId) {
        return (ContractNegotiation)this.transactionContext.execute(() -> (ContractNegotiation)this.store.findById(contractNegotiationId));
    }

    public ServiceResult<List<ContractNegotiation>> search(QuerySpec query) {
        return (ServiceResult)this.queryValidator.validate(query).flatMap(validation -> validation.failed() ? ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", validation.getFailureDetail())}) : ServiceResult.success(this.queryNegotiations(query)));
    }

    public String getState(String negotiationId) {
        return Optional.of(negotiationId).map(this::findbyId).map(StatefulEntity::getState).map(ContractNegotiationStates::from).map(Enum::name).orElse(null);
    }

    public ContractAgreement getForNegotiation(String negotiationId) {
        return (ContractAgreement)this.transactionContext.execute(() -> Optional.ofNullable((ContractNegotiation)this.store.findById(negotiationId)).map(ContractNegotiation::getContractAgreement).orElse(null));
    }

    public ContractNegotiation initiateNegotiation(ContractRequest request) {
        return (ContractNegotiation)this.transactionContext.execute(() -> (ContractNegotiation)this.consumerManager.initiate(request).getContent());
    }

    public ServiceResult<Void> terminate(TerminateNegotiationCommand command) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute((EntityCommand)command).flatMap(ServiceResult::from));
    }

    private List<ContractNegotiation> queryNegotiations(QuerySpec query) {
        return (List)this.transactionContext.execute(() -> {
            try (Stream stream = this.store.queryNegotiations(query);){
                List list = stream.toList();
                return list;
            }
        });
    }
}

