/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.contractnegotiation;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.observe.ContractNegotiationObservable;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.ConsumerOfferResolver;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.protocol.ContractRemoteMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ValidatableConsumerOffer;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ValidatedConsumerOffer;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolTokenValidator;
import org.eclipse.edc.participant.spi.ParticipantAgent;
import org.eclipse.edc.policy.context.request.spi.RequestContractNegotiationPolicyContext;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class ContractNegotiationProtocolServiceImpl
implements ContractNegotiationProtocolService {
    private final ContractNegotiationStore store;
    private final TransactionContext transactionContext;
    private final ContractValidationService validationService;
    private final ConsumerOfferResolver consumerOfferResolver;
    private final ProtocolTokenValidator protocolTokenValidator;
    private final ContractNegotiationObservable observable;
    private final Monitor monitor;
    private final Telemetry telemetry;

    public ContractNegotiationProtocolServiceImpl(ContractNegotiationStore store, TransactionContext transactionContext, ContractValidationService validationService, ConsumerOfferResolver consumerOfferResolver, ProtocolTokenValidator protocolTokenValidator, ContractNegotiationObservable observable, Monitor monitor, Telemetry telemetry) {
        this.store = store;
        this.transactionContext = transactionContext;
        this.validationService = validationService;
        this.consumerOfferResolver = consumerOfferResolver;
        this.protocolTokenValidator = protocolTokenValidator;
        this.observable = observable;
        this.monitor = monitor;
        this.telemetry = telemetry;
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyRequested(ContractRequestMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.fetchValidatableOffer(message).compose(validatableOffer -> (ServiceResult)((ServiceResult)this.verifyRequest(tokenRepresentation, validatableOffer.getContractPolicy(), (RemoteMessage)message).compose(agent -> this.validateOffer((ParticipantAgent)agent, (ValidatableConsumerOffer)validatableOffer))).compose(validatedOffer -> {
            ServiceResult<ContractNegotiation> result = message.getProviderPid() == null ? this.createNegotiation((ContractRemoteMessage)message, validatedOffer.getConsumerIdentity(), ContractNegotiation.Type.PROVIDER, message.getCallbackAddress()) : this.getAndLeaseNegotiation(message.getProviderPid());
            return (ServiceResult)result.onSuccess(negotiation -> {
                if (negotiation.shouldIgnoreIncomingMessage(message.getId())) {
                    return;
                }
                negotiation.protocolMessageReceived(message.getId());
                negotiation.addContractOffer(validatedOffer.getOffer());
                negotiation.transitionRequested();
                this.update((ContractNegotiation)negotiation);
                this.observable.invokeForEach(l -> l.requested(negotiation));
            });
        })));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyOffered(ContractOfferMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.verifyRequest(tokenRepresentation, message.getContractOffer().getPolicy(), (RemoteMessage)message).compose(agent -> {
            ServiceResult result = message.getConsumerPid() == null ? this.createNegotiation((ContractRemoteMessage)message, agent.getIdentity(), ContractNegotiation.Type.CONSUMER, message.getCallbackAddress()) : (ServiceResult)this.getAndLeaseNegotiation(message.getConsumerPid()).compose(negotiation -> (ServiceResult)this.validateRequest((ParticipantAgent)agent, (ContractNegotiation)negotiation).map(it -> negotiation));
            return (ServiceResult)result.onSuccess(negotiation -> {
                if (negotiation.shouldIgnoreIncomingMessage(message.getId())) {
                    return;
                }
                negotiation.protocolMessageReceived(message.getId());
                negotiation.addContractOffer(message.getContractOffer());
                negotiation.transitionOffered();
                this.update((ContractNegotiation)negotiation);
                this.observable.invokeForEach(l -> l.offered(negotiation));
            });
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyAccepted(ContractNegotiationEventMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation(message.getProcessId()).compose(contractNegotiation -> (ServiceResult)this.verifyRequest(tokenRepresentation, contractNegotiation.getLastContractOffer().getPolicy(), (RemoteMessage)message).compose(agent -> this.validateRequest((ParticipantAgent)agent, (ContractNegotiation)contractNegotiation)))).compose(cn -> this.onMessageDo((ContractRemoteMessage)message, contractNegotiation -> this.acceptedAction(message, (ContractNegotiation)contractNegotiation))));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyAgreed(ContractAgreementMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation(message.getProcessId()).compose(contractNegotiation -> (ServiceResult)this.verifyRequest(tokenRepresentation, contractNegotiation.getLastContractOffer().getPolicy(), (RemoteMessage)message).compose(agent -> this.validateAgreed(message, (ParticipantAgent)agent, (ContractNegotiation)contractNegotiation)))).compose(cn -> this.onMessageDo((ContractRemoteMessage)message, contractNegotiation -> this.agreedAction(message, (ContractNegotiation)contractNegotiation))));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyVerified(ContractAgreementVerificationMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation(message.getProcessId()).compose(contractNegotiation -> (ServiceResult)this.verifyRequest(tokenRepresentation, contractNegotiation.getLastContractOffer().getPolicy(), (RemoteMessage)message).compose(agent -> this.validateRequest((ParticipantAgent)agent, (ContractNegotiation)contractNegotiation)))).compose(cn -> this.onMessageDo((ContractRemoteMessage)message, contractNegotiation -> this.verifiedAction(message, (ContractNegotiation)contractNegotiation))));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyFinalized(ContractNegotiationEventMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation(message.getProcessId()).compose(contractNegotiation -> (ServiceResult)this.verifyRequest(tokenRepresentation, contractNegotiation.getLastContractOffer().getPolicy(), (RemoteMessage)message).compose(agent -> this.validateRequest((ParticipantAgent)agent, (ContractNegotiation)contractNegotiation)))).compose(cn -> this.onMessageDo((ContractRemoteMessage)message, contractNegotiation -> this.finalizedAction(message, (ContractNegotiation)contractNegotiation))));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyTerminated(ContractNegotiationTerminationMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation(message.getProcessId()).compose(contractNegotiation -> (ServiceResult)this.verifyRequest(tokenRepresentation, contractNegotiation.getLastContractOffer().getPolicy(), (RemoteMessage)message).compose(agent -> this.validateRequest((ParticipantAgent)agent, (ContractNegotiation)contractNegotiation)))).compose(cn -> this.onMessageDo((ContractRemoteMessage)message, contractNegotiation -> this.terminatedAction(message, (ContractNegotiation)contractNegotiation))));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> findById(String id, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.getNegotiation(id).compose(contractNegotiation -> (ServiceResult)this.verifyRequest(tokenRepresentation, contractNegotiation.getLastContractOffer().getPolicy(), null).compose(agent -> (ServiceResult)this.validateRequest((ParticipantAgent)agent, (ContractNegotiation)contractNegotiation).map(it -> contractNegotiation))));
    }

    @NotNull
    private ServiceResult<ContractNegotiation> onMessageDo(ContractRemoteMessage message, Function<ContractNegotiation, ServiceResult<ContractNegotiation>> action) {
        return (ServiceResult)this.getAndLeaseNegotiation(message.getProcessId()).compose(contractNegotiation -> {
            if (contractNegotiation.shouldIgnoreIncomingMessage(message.getId())) {
                return ServiceResult.success((Object)contractNegotiation);
            }
            return (ServiceResult)action.apply((ContractNegotiation)contractNegotiation);
        });
    }

    @NotNull
    private ServiceResult<ContractNegotiation> createNegotiation(ContractRemoteMessage message, String counterPartyIdentity, ContractNegotiation.Type type, String callbackAddress) {
        ContractNegotiation negotiation = ((ContractNegotiation.Builder)((ContractNegotiation.Builder)ContractNegotiation.Builder.newInstance().id(UUID.randomUUID().toString())).correlationId(message.getConsumerPid()).counterPartyId(counterPartyIdentity).counterPartyAddress(callbackAddress).protocol(message.getProtocol()).traceContext(this.telemetry.getCurrentTraceContext())).type(type).build();
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ValidatedConsumerOffer> validateOffer(ParticipantAgent agent, ValidatableConsumerOffer consumerOffer) {
        Result result = this.validationService.validateInitialOffer(agent, consumerOffer);
        if (result.failed()) {
            this.monitor.debug("[Provider] Contract offer rejected as invalid: " + result.getFailureDetail(), new Throwable[0]);
            return ServiceResult.badRequest((String[])new String[]{"Contract offer is not valid: " + result.getFailureDetail()});
        }
        return ServiceResult.success((Object)((ValidatedConsumerOffer)result.getContent()));
    }

    @NotNull
    private ServiceResult<ValidatableConsumerOffer> fetchValidatableOffer(ContractRequestMessage message) {
        String offerId = message.getContractOffer().getId();
        ServiceResult result = this.consumerOfferResolver.resolveOffer(offerId);
        if (result.failed()) {
            this.monitor.debug(() -> "Failed to resolve offer: %s".formatted(result.getFailureDetail()), new Throwable[0]);
            return ServiceResult.notFound((String)"Not found");
        }
        return result;
    }

    @NotNull
    private ServiceResult<ContractNegotiation> validateAgreed(ContractAgreementMessage message, ParticipantAgent agent, ContractNegotiation negotiation) {
        ContractAgreement agreement = message.getContractAgreement();
        Result result = this.validationService.validateConfirmed(agent, agreement, negotiation.getLastContractOffer());
        if (result.failed()) {
            String msg = "Contract agreement received. Validation failed: " + result.getFailureDetail();
            this.monitor.debug("[Consumer] " + msg, new Throwable[0]);
            return ServiceResult.badRequest((String[])new String[]{msg});
        }
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<Void> validateRequest(ParticipantAgent agent, ContractNegotiation negotiation) {
        Result result = this.validationService.validateRequest(agent, negotiation);
        if (result.failed()) {
            return ServiceResult.badRequest((String[])new String[]{"Invalid client credentials: " + result.getFailureDetail()});
        }
        return ServiceResult.success();
    }

    @NotNull
    private ServiceResult<ContractNegotiation> acceptedAction(ContractNegotiationEventMessage message, ContractNegotiation negotiation) {
        negotiation.protocolMessageReceived(message.getId());
        negotiation.transitionAccepted();
        this.update(negotiation);
        this.observable.invokeForEach(l -> l.accepted(negotiation));
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ContractNegotiation> agreedAction(ContractAgreementMessage message, ContractNegotiation negotiation) {
        negotiation.protocolMessageReceived(message.getId());
        negotiation.setContractAgreement(message.getContractAgreement());
        negotiation.transitionAgreed();
        this.update(negotiation);
        this.observable.invokeForEach(l -> l.agreed(negotiation));
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ContractNegotiation> verifiedAction(ContractAgreementVerificationMessage message, ContractNegotiation negotiation) {
        negotiation.protocolMessageReceived(message.getId());
        negotiation.transitionVerified();
        this.update(negotiation);
        this.observable.invokeForEach(l -> l.verified(negotiation));
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ContractNegotiation> finalizedAction(ContractNegotiationEventMessage message, ContractNegotiation negotiation) {
        negotiation.protocolMessageReceived(message.getId());
        negotiation.transitionFinalized();
        this.update(negotiation);
        this.observable.invokeForEach(l -> l.finalized(negotiation));
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ContractNegotiation> terminatedAction(ContractNegotiationTerminationMessage message, ContractNegotiation negotiation) {
        negotiation.protocolMessageReceived(message.getId());
        negotiation.transitionTerminated();
        this.update(negotiation);
        this.observable.invokeForEach(l -> l.terminated(negotiation));
        return ServiceResult.success((Object)negotiation);
    }

    private ServiceResult<ContractNegotiation> getAndLeaseNegotiation(String negotiationId) {
        return (ServiceResult)this.store.findByIdAndLease(negotiationId).flatMap(ServiceResult::from);
    }

    private ServiceResult<ParticipantAgent> verifyRequest(TokenRepresentation tokenRepresentation, Policy policy, RemoteMessage message) {
        return (ServiceResult)this.protocolTokenValidator.verify(tokenRepresentation, RequestContractNegotiationPolicyContext::new, policy, message).onFailure(failure -> this.monitor.debug(() -> "Verification Failed: %s".formatted(failure.getFailureDetail()), new Throwable[0]));
    }

    private ServiceResult<ContractNegotiation> getNegotiation(String negotiationId) {
        return Optional.ofNullable((ContractNegotiation)this.store.findById(negotiationId)).map(ServiceResult::success).orElseGet(() -> ServiceResult.notFound((String)"No negotiation with id %s found".formatted(negotiationId)));
    }

    private void update(ContractNegotiation negotiation) {
        this.store.save((Object)negotiation);
        this.monitor.debug(() -> "[%s] ContractNegotiation %s is now in state %s.".formatted(negotiation.getType(), negotiation.getId(), negotiation.stateAsString()), new Throwable[0]);
    }
}

