/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.contractdefinition;

import java.time.Clock;
import org.eclipse.edc.connector.controlplane.contract.spi.definition.observe.ContractDefinitionListener;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractdefinition.ContractDefinitionCreated;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractdefinition.ContractDefinitionDeleted;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractdefinition.ContractDefinitionEvent;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractdefinition.ContractDefinitionUpdated;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.spi.event.Event;
import org.eclipse.edc.spi.event.EventEnvelope;
import org.eclipse.edc.spi.event.EventRouter;

public class ContractDefinitionEventListener
implements ContractDefinitionListener {
    private final Clock clock;
    private final EventRouter eventRouter;

    public ContractDefinitionEventListener(Clock clock, EventRouter eventRouter) {
        this.clock = clock;
        this.eventRouter = eventRouter;
    }

    public void created(ContractDefinition contractDefinition) {
        ContractDefinitionCreated event = (ContractDefinitionCreated)((ContractDefinitionCreated.Builder)ContractDefinitionCreated.Builder.newInstance().contractDefinitionId(contractDefinition.getId())).build();
        this.publish((ContractDefinitionEvent)event);
    }

    public void deleted(ContractDefinition contractDefinition) {
        ContractDefinitionDeleted event = (ContractDefinitionDeleted)((ContractDefinitionDeleted.Builder)ContractDefinitionDeleted.Builder.newInstance().contractDefinitionId(contractDefinition.getId())).build();
        this.publish((ContractDefinitionEvent)event);
    }

    public void updated(ContractDefinition contractDefinition) {
        ContractDefinitionUpdated event = (ContractDefinitionUpdated)((ContractDefinitionUpdated.Builder)ContractDefinitionUpdated.Builder.newInstance().contractDefinitionId(contractDefinition.getId())).build();
        this.publish((ContractDefinitionEvent)event);
    }

    private void publish(ContractDefinitionEvent event) {
        EventEnvelope envelope = EventEnvelope.Builder.newInstance().payload((Event)event).at(this.clock.millis()).build();
        this.eventRouter.publish(envelope);
    }
}

