/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.contractagreement;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidator;
import org.eclipse.edc.connector.controlplane.services.spi.contractagreement.ContractAgreementService;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class ContractAgreementServiceImpl
implements ContractAgreementService {
    private final ContractNegotiationStore store;
    private final TransactionContext transactionContext;
    private final QueryValidator queryValidator;

    public ContractAgreementServiceImpl(ContractNegotiationStore store, TransactionContext transactionContext, QueryValidator queryValidator) {
        this.store = store;
        this.transactionContext = transactionContext;
        this.queryValidator = queryValidator;
    }

    public ContractAgreement findById(String contractAgreementId) {
        return (ContractAgreement)this.transactionContext.execute(() -> this.store.findContractAgreement(contractAgreementId));
    }

    public ServiceResult<List<ContractAgreement>> search(QuerySpec query) {
        return (ServiceResult)this.queryValidator.validate(query).flatMap(validation -> validation.failed() ? ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", validation.getFailureDetail())}) : ServiceResult.success(this.queryAgreements(query)));
    }

    public ContractNegotiation findNegotiation(String contractAgreementId) {
        Criterion criterion = Criterion.criterion((Object)"contractAgreement.id", (String)"=", (Object)contractAgreementId);
        QuerySpec query = QuerySpec.Builder.newInstance().filter(criterion).build();
        return (ContractNegotiation)this.transactionContext.execute(() -> this.store.queryNegotiations(query).findFirst().orElse(null));
    }

    private List<ContractAgreement> queryAgreements(QuerySpec query) {
        return (List)this.transactionContext.execute(() -> {
            try (Stream stream = this.store.queryAgreements(query);){
                List list = stream.toList();
                return list;
            }
        });
    }
}

