/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.catalog;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.edc.connector.controlplane.catalog.spi.Catalog;
import org.eclipse.edc.connector.controlplane.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.connector.controlplane.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.controlplane.catalog.spi.Dataset;
import org.eclipse.edc.connector.controlplane.catalog.spi.DatasetResolver;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolTokenValidator;
import org.eclipse.edc.policy.context.request.spi.RequestCatalogPolicyContext;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class CatalogProtocolServiceImpl
implements CatalogProtocolService {
    private final DatasetResolver datasetResolver;
    private final DataServiceRegistry dataServiceRegistry;
    private final String participantId;
    private final TransactionContext transactionContext;
    private final ProtocolTokenValidator protocolTokenValidator;

    public CatalogProtocolServiceImpl(DatasetResolver datasetResolver, DataServiceRegistry dataServiceRegistry, ProtocolTokenValidator protocolTokenValidator, String participantId, TransactionContext transactionContext) {
        this.datasetResolver = datasetResolver;
        this.dataServiceRegistry = dataServiceRegistry;
        this.protocolTokenValidator = protocolTokenValidator;
        this.participantId = participantId;
        this.transactionContext = transactionContext;
    }

    @NotNull
    public ServiceResult<Catalog> getCatalog(CatalogRequestMessage message, TokenRepresentation tokenRepresentation) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.protocolTokenValidator.verify(tokenRepresentation, RequestCatalogPolicyContext::new, (RemoteMessage)message).map(agent -> {
            try (Stream datasets = this.datasetResolver.query(agent, message.getQuerySpec(), message.getProtocol());){
                List dataServices = this.dataServiceRegistry.getDataServices(message.getProtocol());
                Catalog catalog = (Catalog)Catalog.Builder.newInstance().dataServices(dataServices).datasets(datasets.toList()).participantId(this.participantId).build();
                return catalog;
            }
        }));
    }

    @NotNull
    public ServiceResult<Dataset> getDataset(String datasetId, TokenRepresentation tokenRepresentation, String protocol) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.protocolTokenValidator.verify(tokenRepresentation, RequestCatalogPolicyContext::new).map(agent -> this.datasetResolver.getById(agent, datasetId, protocol)).compose(dataset -> {
            if (dataset == null) {
                return ServiceResult.notFound((String)String.format("Dataset %s does not exist", datasetId));
            }
            return ServiceResult.success((Object)dataset);
        }));
    }
}

