/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.asset;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.connector.controlplane.asset.spi.index.AssetIndex;
import org.eclipse.edc.connector.controlplane.asset.spi.observe.AssetObservable;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidator;
import org.eclipse.edc.connector.controlplane.services.spi.asset.AssetService;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;

public class AssetServiceImpl
implements AssetService {
    private static final String ASSET_ID_QUERY = "contractAgreement.assetId";
    private static final String DUPLICATED_KEYS_MESSAGE = "Duplicate keys in properties and private properties are not allowed";
    private final AssetIndex index;
    private final ContractNegotiationStore contractNegotiationStore;
    private final TransactionContext transactionContext;
    private final AssetObservable observable;
    private final DataAddressValidatorRegistry dataAddressValidator;
    private final QueryValidator queryValidator;

    public AssetServiceImpl(AssetIndex index, ContractNegotiationStore contractNegotiationStore, TransactionContext transactionContext, AssetObservable observable, DataAddressValidatorRegistry dataAddressValidator, QueryValidator queryValidator) {
        this.index = index;
        this.contractNegotiationStore = contractNegotiationStore;
        this.transactionContext = transactionContext;
        this.observable = observable;
        this.dataAddressValidator = dataAddressValidator;
        this.queryValidator = queryValidator;
    }

    public Asset findById(String assetId) {
        return (Asset)this.transactionContext.execute(() -> this.index.findById(assetId));
    }

    public ServiceResult<List<Asset>> search(QuerySpec query) {
        return (ServiceResult)this.queryValidator.validate(query).flatMap(validation -> validation.failed() ? ServiceResult.badRequest((List)validation.getFailureMessages()) : ServiceResult.success(this.queryAssets(query)));
    }

    public ServiceResult<Asset> create(Asset asset) {
        if (asset.hasDuplicatePropertyKeys()) {
            return ServiceResult.badRequest((String[])new String[]{DUPLICATED_KEYS_MESSAGE});
        }
        ValidationResult validDataAddress = this.dataAddressValidator.validateSource(asset.getDataAddress());
        if (validDataAddress.failed()) {
            return ServiceResult.badRequest((List)validDataAddress.getFailureMessages());
        }
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult createResult = this.index.create(asset);
            if (createResult.succeeded()) {
                this.observable.invokeForEach(l -> l.created(asset));
                return ServiceResult.success((Object)asset);
            }
            return ServiceResult.fromFailure((StoreResult)createResult);
        });
    }

    public ServiceResult<Asset> delete(String assetId) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            QuerySpec query = QuerySpec.Builder.newInstance().filter(List.of(new Criterion((Object)ASSET_ID_QUERY, "=", (Object)assetId))).build();
            try (Stream negotiationsOnAsset = this.contractNegotiationStore.queryNegotiations(query);){
                if (negotiationsOnAsset.anyMatch(new AssetLockedPredicate())) {
                    ServiceResult serviceResult = ServiceResult.conflict((String)String.format("Asset %s cannot be deleted as it is referenced by at least one contract agreement or an ongoing negotiation", assetId));
                    return serviceResult;
                }
            }
            StoreResult deleted = this.index.deleteById(assetId);
            deleted.onSuccess(a -> this.observable.invokeForEach(l -> l.deleted(a)));
            return ServiceResult.from((StoreResult)deleted);
        });
    }

    public ServiceResult<Asset> update(Asset asset) {
        if (asset.hasDuplicatePropertyKeys()) {
            return ServiceResult.badRequest((String[])new String[]{DUPLICATED_KEYS_MESSAGE});
        }
        ValidationResult validDataAddress = this.dataAddressValidator.validateSource(asset.getDataAddress());
        if (validDataAddress.failed()) {
            return ServiceResult.badRequest((List)validDataAddress.getFailureMessages());
        }
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult updatedAsset = this.index.updateAsset(asset);
            updatedAsset.onSuccess(a -> this.observable.invokeForEach(l -> l.updated(a)));
            return ServiceResult.from((StoreResult)updatedAsset);
        });
    }

    private List<Asset> queryAssets(QuerySpec query) {
        return (List)this.transactionContext.execute(() -> {
            try (Stream stream = this.index.queryAssets(query);){
                List list = stream.toList();
                return list;
            }
        });
    }

    private static final class AssetLockedPredicate
    implements Predicate<ContractNegotiation> {
        private AssetLockedPredicate() {
        }

        @Override
        public boolean test(ContractNegotiation contractNegotiation) {
            return contractNegotiation.getContractAgreement() != null || !ContractNegotiationStates.isFinal((int)contractNegotiation.getState());
        }
    }
}

