/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services.asset;

import java.util.regex.Pattern;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidator;
import org.eclipse.edc.spi.result.Result;

public class AssetQueryValidator
extends QueryValidator {
    private static final Pattern VALID_QUERY_PATH_REGEX = Pattern.compile("^[A-Za-z_']+.*$");

    public AssetQueryValidator() {
        super(Asset.class);
    }

    @Override
    protected Result<Void> isValid(String path) {
        if (VALID_QUERY_PATH_REGEX.matcher(path).matches()) {
            return Result.success();
        }
        return Result.failure((String)String.format("The query path must start with a letter or an '_' but was '%s'", path));
    }
}

