/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.services;

import java.time.Clock;
import org.eclipse.edc.connector.controlplane.asset.spi.index.AssetIndex;
import org.eclipse.edc.connector.controlplane.asset.spi.observe.AssetObservable;
import org.eclipse.edc.connector.controlplane.asset.spi.observe.AssetObservableImpl;
import org.eclipse.edc.connector.controlplane.catalog.spi.DataServiceRegistry;
import org.eclipse.edc.connector.controlplane.catalog.spi.DatasetResolver;
import org.eclipse.edc.connector.controlplane.contract.spi.definition.observe.ContractDefinitionObservable;
import org.eclipse.edc.connector.controlplane.contract.spi.definition.observe.ContractDefinitionObservableImpl;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ConsumerContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.observe.ContractNegotiationObservable;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.ConsumerOfferResolver;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.store.ContractDefinitionStore;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.controlplane.policy.spi.observe.PolicyDefinitionObservable;
import org.eclipse.edc.connector.controlplane.policy.spi.observe.PolicyDefinitionObservableImpl;
import org.eclipse.edc.connector.controlplane.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.connector.controlplane.services.asset.AssetEventListener;
import org.eclipse.edc.connector.controlplane.services.asset.AssetQueryValidator;
import org.eclipse.edc.connector.controlplane.services.asset.AssetServiceImpl;
import org.eclipse.edc.connector.controlplane.services.catalog.CatalogProtocolServiceImpl;
import org.eclipse.edc.connector.controlplane.services.catalog.CatalogServiceImpl;
import org.eclipse.edc.connector.controlplane.services.contractagreement.ContractAgreementServiceImpl;
import org.eclipse.edc.connector.controlplane.services.contractdefinition.ContractDefinitionEventListener;
import org.eclipse.edc.connector.controlplane.services.contractdefinition.ContractDefinitionServiceImpl;
import org.eclipse.edc.connector.controlplane.services.contractnegotiation.ContractNegotiationProtocolServiceImpl;
import org.eclipse.edc.connector.controlplane.services.contractnegotiation.ContractNegotiationServiceImpl;
import org.eclipse.edc.connector.controlplane.services.policydefinition.PolicyDefinitionEventListener;
import org.eclipse.edc.connector.controlplane.services.policydefinition.PolicyDefinitionServiceImpl;
import org.eclipse.edc.connector.controlplane.services.protocol.ProtocolTokenValidatorImpl;
import org.eclipse.edc.connector.controlplane.services.protocol.VersionProtocolServiceImpl;
import org.eclipse.edc.connector.controlplane.services.protocol.VersionServiceImpl;
import org.eclipse.edc.connector.controlplane.services.query.QueryValidators;
import org.eclipse.edc.connector.controlplane.services.secret.SecretEventListener;
import org.eclipse.edc.connector.controlplane.services.secret.SecretServiceImpl;
import org.eclipse.edc.connector.controlplane.services.spi.asset.AssetService;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.catalog.CatalogService;
import org.eclipse.edc.connector.controlplane.services.spi.contractagreement.ContractAgreementService;
import org.eclipse.edc.connector.controlplane.services.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.connector.controlplane.services.spi.policydefinition.PolicyDefinitionService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolTokenValidator;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolVersionRegistry;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionService;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.controlplane.services.transferprocess.TransferProcessProtocolServiceImpl;
import org.eclipse.edc.connector.controlplane.services.transferprocess.TransferProcessServiceImpl;
import org.eclipse.edc.connector.controlplane.transfer.spi.TransferProcessManager;
import org.eclipse.edc.connector.controlplane.transfer.spi.flow.TransferTypeParser;
import org.eclipse.edc.connector.controlplane.transfer.spi.observe.TransferProcessObservable;
import org.eclipse.edc.connector.controlplane.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.connector.secret.spi.observe.SecretObservable;
import org.eclipse.edc.connector.secret.spi.observe.SecretObservableImpl;
import org.eclipse.edc.connector.spi.service.SecretService;
import org.eclipse.edc.participant.spi.ParticipantAgentService;
import org.eclipse.edc.policy.context.request.spi.RequestCatalogPolicyContext;
import org.eclipse.edc.policy.context.request.spi.RequestContractNegotiationPolicyContext;
import org.eclipse.edc.policy.context.request.spi.RequestTransferProcessPolicyContext;
import org.eclipse.edc.policy.context.request.spi.RequestVersionPolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;

@Extension(value="Control Plane Services")
public class ControlPlaneServicesExtension
implements ServiceExtension {
    public static final String NAME = "Control Plane Services";
    @Setting(description="If true enables the policy validation when creating and updating policy definitions", defaultValue="false", key="edc.policy.validation.enabled")
    private Boolean validatePolicy;
    @Inject
    private Clock clock;
    @Inject
    private Monitor monitor;
    @Inject
    private EventRouter eventRouter;
    @Inject
    private RemoteMessageDispatcherRegistry dispatcher;
    @Inject
    private AssetIndex assetIndex;
    @Inject
    private Vault vault;
    @Inject
    private ContractDefinitionStore contractDefinitionStore;
    @Inject
    private ContractNegotiationStore contractNegotiationStore;
    @Inject
    private ConsumerContractNegotiationManager consumerContractNegotiationManager;
    @Inject
    private PolicyDefinitionStore policyDefinitionStore;
    @Inject
    private TransferProcessStore transferProcessStore;
    @Inject
    private TransferProcessManager transferProcessManager;
    @Inject
    private TransactionContext transactionContext;
    @Inject
    private ContractValidationService contractValidationService;
    @Inject
    private ConsumerOfferResolver consumerOfferResolver;
    @Inject
    private ContractNegotiationObservable contractNegotiationObservable;
    @Inject
    private TransferProcessObservable transferProcessObservable;
    @Inject
    private Telemetry telemetry;
    @Inject
    private ParticipantAgentService participantAgentService;
    @Inject
    private DataServiceRegistry dataServiceRegistry;
    @Inject
    private DatasetResolver datasetResolver;
    @Inject
    private CommandHandlerRegistry commandHandlerRegistry;
    @Inject
    private DataAddressValidatorRegistry dataAddressValidator;
    @Inject
    private IdentityService identityService;
    @Inject
    private PolicyEngine policyEngine;
    @Inject(required=false)
    private ProtocolTokenValidator protocolTokenValidator;
    @Inject
    private ProtocolVersionRegistry protocolVersionRegistry;
    @Inject
    private TransferTypeParser transferTypeParser;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.policyEngine.registerScope("request.transfer.process", RequestTransferProcessPolicyContext.class);
        this.policyEngine.registerScope("request.contract.negotiation", RequestContractNegotiationPolicyContext.class);
        this.policyEngine.registerScope("request.catalog", RequestCatalogPolicyContext.class);
        this.policyEngine.registerScope("request.version", RequestVersionPolicyContext.class);
    }

    @Provider
    public AssetService assetService() {
        AssetObservableImpl assetObservable = new AssetObservableImpl();
        assetObservable.registerListener((Object)new AssetEventListener(this.clock, this.eventRouter));
        return new AssetServiceImpl(this.assetIndex, this.contractNegotiationStore, this.transactionContext, (AssetObservable)assetObservable, this.dataAddressValidator, new AssetQueryValidator());
    }

    @Provider
    public SecretService secretService() {
        SecretObservableImpl secretObservable = new SecretObservableImpl();
        secretObservable.registerListener((Object)new SecretEventListener(this.clock, this.eventRouter));
        return new SecretServiceImpl(this.vault, (SecretObservable)secretObservable);
    }

    @Provider
    public CatalogService catalogService() {
        return new CatalogServiceImpl(this.dispatcher);
    }

    @Provider
    public CatalogProtocolService catalogProtocolService(ServiceExtensionContext context) {
        return new CatalogProtocolServiceImpl(this.datasetResolver, this.dataServiceRegistry, this.protocolTokenValidator(), context.getParticipantId(), this.transactionContext);
    }

    @Provider
    public ContractAgreementService contractAgreementService() {
        return new ContractAgreementServiceImpl(this.contractNegotiationStore, this.transactionContext, QueryValidators.contractAgreement());
    }

    @Provider
    public ContractDefinitionService contractDefinitionService() {
        ContractDefinitionObservableImpl contractDefinitionObservable = new ContractDefinitionObservableImpl();
        contractDefinitionObservable.registerListener((Object)new ContractDefinitionEventListener(this.clock, this.eventRouter));
        return new ContractDefinitionServiceImpl(this.contractDefinitionStore, this.transactionContext, (ContractDefinitionObservable)contractDefinitionObservable, QueryValidators.contractDefinition());
    }

    @Provider
    public ContractNegotiationService contractNegotiationService() {
        return new ContractNegotiationServiceImpl(this.contractNegotiationStore, this.consumerContractNegotiationManager, this.transactionContext, this.commandHandlerRegistry, QueryValidators.contractNegotiation());
    }

    @Provider
    public ContractNegotiationProtocolService contractNegotiationProtocolService() {
        return new ContractNegotiationProtocolServiceImpl(this.contractNegotiationStore, this.transactionContext, this.contractValidationService, this.consumerOfferResolver, this.protocolTokenValidator(), this.contractNegotiationObservable, this.monitor, this.telemetry);
    }

    @Provider
    public PolicyDefinitionService policyDefinitionService() {
        PolicyDefinitionObservableImpl policyDefinitionObservable = new PolicyDefinitionObservableImpl();
        policyDefinitionObservable.registerListener((Object)new PolicyDefinitionEventListener(this.clock, this.eventRouter));
        return new PolicyDefinitionServiceImpl(this.transactionContext, this.policyDefinitionStore, this.contractDefinitionStore, (PolicyDefinitionObservable)policyDefinitionObservable, this.policyEngine, QueryValidators.policyDefinition(), this.validatePolicy);
    }

    @Provider
    public TransferProcessService transferProcessService() {
        return new TransferProcessServiceImpl(this.transferProcessStore, this.transferProcessManager, this.transactionContext, this.dataAddressValidator, this.commandHandlerRegistry, this.transferTypeParser, this.contractNegotiationStore, QueryValidators.transferProcess());
    }

    @Provider
    public TransferProcessProtocolService transferProcessProtocolService() {
        return new TransferProcessProtocolServiceImpl(this.transferProcessStore, this.transactionContext, this.contractNegotiationStore, this.contractValidationService, this.protocolTokenValidator(), this.dataAddressValidator, this.transferProcessObservable, this.clock, this.monitor, this.telemetry);
    }

    @Provider
    public ProtocolTokenValidator protocolTokenValidator() {
        if (this.protocolTokenValidator == null) {
            this.protocolTokenValidator = new ProtocolTokenValidatorImpl(this.identityService, this.policyEngine, this.monitor, this.participantAgentService);
        }
        return this.protocolTokenValidator;
    }

    @Provider
    public VersionProtocolService versionProtocolService() {
        return new VersionProtocolServiceImpl(this.protocolVersionRegistry);
    }

    @Provider
    public VersionService versionService() {
        return new VersionServiceImpl(this.dispatcher);
    }
}

