/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.store.sql.contractnegotiation.store.schema;

import org.eclipse.edc.connector.store.sql.contractnegotiation.store.schema.ContractNegotiationStatements;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.sql.statement.SqlExecuteStatement;
import org.eclipse.edc.sql.translation.SqlQueryStatement;

public class BaseSqlDialectStatements
implements ContractNegotiationStatements {
    @Override
    public String getFindTemplate() {
        return String.format("SELECT * FROM %s LEFT OUTER JOIN %s ON %s.%s = %s.%s WHERE %s.%s = ?;", this.getContractNegotiationTable(), this.getContractAgreementTable(), this.getContractNegotiationTable(), this.getContractAgreementIdFkColumn(), this.getContractAgreementTable(), this.getContractAgreementIdColumn(), this.getContractNegotiationTable(), this.getIdColumn());
    }

    @Override
    public String getFindContractAgreementTemplate() {
        return String.format("SELECT * FROM %s where %s=?;", this.getContractAgreementTable(), this.getContractAgreementIdColumn());
    }

    @Override
    public String getUpdateNegotiationTemplate() {
        return this.executeStatement().column(this.getStateColumn()).column(this.getStateCountColumn()).column(this.getStateTimestampColumn()).column(this.getErrorDetailColumn()).jsonColumn(this.getContractOffersColumn()).jsonColumn(this.getCallbackAddressesColumn()).jsonColumn(this.getTraceContextColumn()).column(this.getContractAgreementIdFkColumn()).column(this.getUpdatedAtColumn()).column(this.getPendingColumn()).update(this.getContractNegotiationTable(), this.getIdColumn());
    }

    @Override
    public String getInsertNegotiationTemplate() {
        return this.executeStatement().column(this.getIdColumn()).column(this.getCorrelationIdColumn()).column(this.getCounterPartyIdColumn()).column(this.getCounterPartyAddressColumn()).column(this.getTypeColumn()).column(this.getProtocolColumn()).column(this.getStateColumn()).column(this.getStateCountColumn()).column(this.getStateTimestampColumn()).column(this.getErrorDetailColumn()).column(this.getContractAgreementIdFkColumn()).jsonColumn(this.getContractOffersColumn()).jsonColumn(this.getCallbackAddressesColumn()).jsonColumn(this.getTraceContextColumn()).column(this.getCreatedAtColumn()).column(this.getUpdatedAtColumn()).column(this.getPendingColumn()).insertInto(this.getContractNegotiationTable());
    }

    @Override
    public String getDeleteTemplate() {
        return this.executeStatement().delete(this.getContractNegotiationTable(), new Criterion[]{SqlExecuteStatement.equalTo((String)this.getIdColumn()), SqlExecuteStatement.isNull((String)this.getContractAgreementIdFkColumn())});
    }

    @Override
    public String getSelectFromAgreementsTemplate() {
        return String.format("SELECT * FROM %s", this.getContractAgreementTable());
    }

    @Override
    public String getInsertAgreementTemplate() {
        return this.executeStatement().column(this.getContractAgreementIdColumn()).column(this.getProviderAgentColumn()).column(this.getConsumerAgentColumn()).column(this.getSigningDateColumn()).column(this.getAssetIdColumn()).jsonColumn(this.getPolicyColumn()).insertInto(this.getContractAgreementTable());
    }

    @Override
    public String getUpdateAgreementTemplate() {
        return this.executeStatement().column(this.getProviderAgentColumn()).column(this.getConsumerAgentColumn()).column(this.getSigningDateColumn()).column(this.getAssetIdColumn()).jsonColumn(this.getPolicyColumn()).update(this.getContractAgreementTable(), this.getContractAgreementIdColumn());
    }

    @Override
    public String getSelectNegotiationsTemplate() {
        return String.format("SELECT * FROM %s LEFT JOIN %s agr ON %s.%s = agr.%s", this.getContractNegotiationTable(), this.getContractAgreementTable(), this.getContractNegotiationTable(), this.getContractAgreementIdFkColumn(), this.getContractAgreementIdColumn());
    }

    @Override
    public SqlQueryStatement createNegotiationsQuery(QuerySpec querySpec) {
        String sql = this.getSelectNegotiationsTemplate();
        SqlQueryStatement stmt = new SqlQueryStatement(sql);
        stmt.addParameter((Object)querySpec.getLimit());
        stmt.addParameter((Object)querySpec.getOffset());
        return stmt;
    }

    @Override
    public SqlQueryStatement createAgreementsQuery(QuerySpec querySpec) {
        String sql = "SELECT * FROM " + this.getContractAgreementTable();
        SqlQueryStatement stmt = new SqlQueryStatement(sql);
        stmt.addParameter((Object)querySpec.getLimit());
        stmt.addParameter((Object)querySpec.getOffset());
        return stmt;
    }

    public String getDeleteLeaseTemplate() {
        return this.executeStatement().delete(this.getLeaseTableName(), this.getLeaseIdColumn());
    }

    public String getInsertLeaseTemplate() {
        return this.executeStatement().column(this.getLeaseIdColumn()).column(this.getLeasedByColumn()).column(this.getLeasedAtColumn()).column(this.getLeaseDurationColumn()).insertInto(this.getLeaseTableName());
    }

    public String getUpdateLeaseTemplate() {
        return this.executeStatement().column(this.getLeaseIdColumn()).update(this.getContractNegotiationTable(), this.getIdColumn());
    }

    public String getFindLeaseByEntityTemplate() {
        return String.format("SELECT * FROM %s  WHERE %s = (SELECT lease_id FROM %s WHERE %s=? )", this.getLeaseTableName(), this.getLeaseIdColumn(), this.getContractNegotiationTable(), this.getIdColumn());
    }
}

