/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.store.sql.contractnegotiation.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.connector.store.sql.contractnegotiation.store.schema.ContractNegotiationStatements;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.ResultSetMapper;
import org.eclipse.edc.sql.lease.LeaseStatements;
import org.eclipse.edc.sql.lease.SqlLeaseContextBuilder;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlContractNegotiationStore
extends AbstractSqlStore
implements ContractNegotiationStore {
    private final ContractNegotiationStatements statements;
    private final SqlLeaseContextBuilder leaseContext;
    private final Clock clock;

    public SqlContractNegotiationStore(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, ContractNegotiationStatements statements, String connectorId, Clock clock, QueryExecutor queryExecutor) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = statements;
        this.clock = clock;
        this.leaseContext = SqlLeaseContextBuilder.with((TransactionContext)transactionContext, (String)connectorId, (LeaseStatements)statements, (Clock)clock, (QueryExecutor)queryExecutor);
    }

    @Nullable
    public ContractNegotiation findById(String negotiationId) {
        return (ContractNegotiation)this.transactionContext.execute(() -> {
            ContractNegotiation contractNegotiation;
            block8: {
                Connection connection = this.getConnection();
                try {
                    contractNegotiation = this.findInternal(connection, negotiationId);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return contractNegotiation;
        });
    }

    @Nullable
    public ContractNegotiation findForCorrelationId(String correlationId) {
        return (ContractNegotiation)this.transactionContext.execute(() -> {
            QuerySpec query = this.correlationIdQuerySpec(correlationId);
            try (Stream<ContractNegotiation> stream = this.queryNegotiations(query);){
                ContractNegotiation contractNegotiation = (ContractNegotiation)this.single(stream.collect(Collectors.toList()));
                return contractNegotiation;
            }
        });
    }

    @Nullable
    public ContractAgreement findContractAgreement(String contractId) {
        return (ContractAgreement)this.transactionContext.execute(() -> {
            ContractAgreement contractAgreement;
            block8: {
                Connection connection = this.getConnection();
                try {
                    contractAgreement = this.findContractAgreementInternal(connection, contractId);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return contractAgreement;
        });
    }

    public void save(ContractNegotiation negotiation) {
        String id = negotiation.getId();
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                ContractNegotiation existing = this.findInternal(connection, id);
                if (existing == null) {
                    this.insert(connection, negotiation);
                } else {
                    this.leaseContext.withConnection(connection).breakLease(id);
                    this.update(connection, id, negotiation);
                }
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public void delete(String negotiationId) {
        this.transactionContext.execute(() -> {
            ContractNegotiation existing = this.findById(negotiationId);
            if (existing != null) {
                if (existing.getContractAgreement() != null) {
                    throw new IllegalStateException(String.format("Cannot delete ContractNegotiation [ID=%s] - ContractAgreement already created.", negotiationId));
                }
                try (Connection connection = this.getConnection();){
                    this.leaseContext.withConnection(connection).acquireLease(negotiationId);
                    String stmt = this.statements.getDeleteTemplate();
                    this.queryExecutor.execute(connection, stmt, new Object[]{negotiationId});
                    this.leaseContext.withConnection(connection).breakLease(negotiationId);
                }
                catch (SQLException e) {
                    throw new EdcPersistenceException((Throwable)e);
                }
            }
        });
    }

    @NotNull
    public Stream<ContractNegotiation> queryNegotiations(QuerySpec querySpec) {
        return (Stream)this.transactionContext.execute(() -> {
            try {
                return this.queryNegotiations(querySpec, this.getConnection());
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    @NotNull
    public Stream<ContractAgreement> queryAgreements(QuerySpec querySpec) {
        return (Stream)this.transactionContext.execute(() -> {
            try {
                SqlQueryStatement statement = this.statements.createAgreementsQuery(querySpec);
                return this.queryExecutor.query(this.getConnection(), true, this::mapContractAgreement, statement.getQueryAsString(), statement.getParameters());
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    @NotNull
    public List<ContractNegotiation> nextNotLeased(int max, Criterion ... criteria) {
        return (List)this.transactionContext.execute(() -> {
            List<Criterion> filter = Arrays.stream(criteria).toList();
            QuerySpec querySpec = QuerySpec.Builder.newInstance().filter(filter).limit(Integer.valueOf(max)).build();
            SqlQueryStatement statement = this.statements.createNegotiationsQuery(querySpec);
            statement.addWhereClause(this.statements.getNotLeasedFilter());
            statement.addParameter((Object)this.clock.millis());
            try (Connection connection = this.getConnection();){
                List<ContractNegotiation> list;
                block14: {
                    Stream stream = this.queryExecutor.query(this.getConnection(), true, this.contractNegotiationWithAgreementMapper(connection), statement.getQueryAsString(), statement.getParameters());
                    try {
                        List<ContractNegotiation> negotiations = stream.collect(Collectors.toList());
                        negotiations.forEach(cn -> this.leaseContext.withConnection(connection).acquireLease(cn.getId()));
                        list = negotiations;
                        if (stream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return list;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public StoreResult<ContractNegotiation> findByIdAndLease(String id) {
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                ContractNegotiation entity = this.findInternal(connection, id);
                if (entity == null) {
                    StoreResult storeResult2 = StoreResult.notFound((String)String.format("ContractNegotiation %s not found", id));
                    return storeResult2;
                }
                this.leaseContext.withConnection(connection).acquireLease(id);
                StoreResult storeResult = StoreResult.success((Object)entity);
                return storeResult;
            }
            catch (IllegalStateException e) {
                return StoreResult.alreadyLeased((String)String.format("ContractNegotiation %s is already leased", id));
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public StoreResult<ContractNegotiation> findByCorrelationIdAndLease(String correlationId) {
        return (StoreResult)this.transactionContext.execute(() -> {
            QuerySpec querySpec = this.correlationIdQuerySpec(correlationId);
            try (Connection connection = this.getConnection();){
                StoreResult storeResult;
                block19: {
                    ContractNegotiation entity;
                    Stream<ContractNegotiation> stream;
                    block17: {
                        StoreResult storeResult2;
                        block18: {
                            stream = this.queryNegotiations(querySpec, connection);
                            try {
                                entity = stream.findFirst().orElse(null);
                                if (entity != null) break block17;
                                storeResult2 = StoreResult.notFound((String)String.format("ContractNegotiation with correlationId %s not found", correlationId));
                                if (stream == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            stream.close();
                        }
                        return storeResult2;
                    }
                    this.leaseContext.withConnection(connection).acquireLease(entity.getId());
                    storeResult = StoreResult.success((Object)entity);
                    if (stream == null) break block19;
                    stream.close();
                }
                return storeResult;
            }
            catch (IllegalStateException e) {
                return StoreResult.alreadyLeased((String)String.format("ContractNegotiation with correlationId %s is already leased", correlationId));
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    private QuerySpec correlationIdQuerySpec(String correlationId) {
        return QuerySpec.Builder.newInstance().filter(List.of(new Criterion((Object)"correlationId", "=", (Object)correlationId))).build();
    }

    private Stream<ContractNegotiation> queryNegotiations(QuerySpec querySpec, Connection connection) {
        SqlQueryStatement statement = this.statements.createNegotiationsQuery(querySpec);
        return this.queryExecutor.query(connection, true, this.contractNegotiationMapper(), statement.getQueryAsString(), statement.getParameters());
    }

    private ContractAgreement findContractAgreementInternal(Connection connection, String contractId) {
        String stmt = this.statements.getFindContractAgreementTemplate();
        return (ContractAgreement)this.queryExecutor.single(connection, false, this::mapContractAgreement, stmt, new Object[]{contractId});
    }

    @Nullable
    private ContractNegotiation findInternal(Connection connection, String id) {
        String sql = this.statements.getFindTemplate();
        return (ContractNegotiation)this.queryExecutor.single(connection, false, this.contractNegotiationMapper(), sql, new Object[]{id});
    }

    private void update(Connection connection, String negotiationId, ContractNegotiation updatedValues) {
        String stmt = this.statements.getUpdateNegotiationTemplate();
        if (updatedValues.getContractAgreement() != null) {
            this.upsertAgreement(updatedValues.getContractAgreement());
        }
        this.queryExecutor.execute(connection, stmt, new Object[]{updatedValues.getState(), updatedValues.getStateCount(), updatedValues.getStateTimestamp(), updatedValues.getErrorDetail(), this.toJson(updatedValues.getContractOffers()), this.toJson(updatedValues.getCallbackAddresses()), this.toJson(updatedValues.getTraceContext()), Optional.ofNullable(updatedValues.getContractAgreement()).map(ContractAgreement::getId).orElse(null), updatedValues.getUpdatedAt(), updatedValues.isPending(), negotiationId});
    }

    private void insert(Connection connection, ContractNegotiation negotiation) {
        String agrId = null;
        ContractAgreement agreement = negotiation.getContractAgreement();
        if (agreement != null) {
            agrId = agreement.getId();
            this.upsertAgreement(agreement);
        }
        String stmt = this.statements.getInsertNegotiationTemplate();
        this.queryExecutor.execute(connection, stmt, new Object[]{negotiation.getId(), negotiation.getCorrelationId(), negotiation.getCounterPartyId(), negotiation.getCounterPartyAddress(), negotiation.getType().name(), negotiation.getProtocol(), negotiation.getState(), negotiation.getStateCount(), negotiation.getStateTimestamp(), negotiation.getErrorDetail(), agrId, this.toJson(negotiation.getContractOffers()), this.toJson(negotiation.getCallbackAddresses()), this.toJson(negotiation.getTraceContext()), negotiation.getCreatedAt(), negotiation.getUpdatedAt(), negotiation.isPending()});
    }

    private void upsertAgreement(ContractAgreement contractAgreement) {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                String agrId = contractAgreement.getId();
                if (this.findContractAgreement(agrId) == null) {
                    String sql = this.statements.getInsertAgreementTemplate();
                    this.queryExecutor.execute(connection, sql, new Object[]{contractAgreement.getId(), contractAgreement.getProviderId(), contractAgreement.getConsumerId(), contractAgreement.getContractSigningDate(), contractAgreement.getAssetId(), this.toJson(contractAgreement.getPolicy())});
                } else {
                    String query = this.statements.getUpdateAgreementTemplate();
                    this.queryExecutor.execute(connection, query, new Object[]{contractAgreement.getProviderId(), contractAgreement.getConsumerId(), contractAgreement.getContractSigningDate(), contractAgreement.getAssetId(), this.toJson(contractAgreement.getPolicy()), agrId});
                }
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    @Nullable
    private <T> T single(List<T> list) {
        if (list.size() > 1) {
            throw new IllegalStateException(this.getMultiplicityError(1, list.size()));
        }
        return list.isEmpty() ? null : (T)list.get(0);
    }

    private ContractAgreement mapContractAgreement(ResultSet resultSet) throws SQLException {
        return ContractAgreement.Builder.newInstance().id(resultSet.getString(this.statements.getContractAgreementIdColumn())).providerId(resultSet.getString(this.statements.getProviderAgentColumn())).consumerId(resultSet.getString(this.statements.getConsumerAgentColumn())).assetId(resultSet.getString(this.statements.getAssetIdColumn())).contractSigningDate(resultSet.getLong(this.statements.getSigningDateColumn())).policy((Policy)this.fromJson(resultSet.getString(this.statements.getPolicyColumn()), (TypeReference)new TypeReference<Policy>(){})).build();
    }

    private String getMultiplicityError(int expectedSize, int actualSize) {
        return String.format("Expected to find %d items, but found %d", expectedSize, actualSize);
    }

    private ResultSetMapper<ContractNegotiation> contractNegotiationMapper() {
        return resultSet -> this.mapContractNegotiation(resultSet, (ResultSetMapper<ContractAgreement>)((ResultSetMapper)this::extractContractAgreement));
    }

    private ResultSetMapper<ContractNegotiation> contractNegotiationWithAgreementMapper(Connection connection) {
        return resultSet -> this.mapContractNegotiation(resultSet, (ResultSetMapper<ContractAgreement>)((ResultSetMapper)rs -> {
            String agreementId = rs.getString(this.statements.getContractAgreementIdFkColumn());
            if (agreementId == null) {
                return null;
            }
            return this.findContractAgreementInternal(connection, agreementId);
        }));
    }

    private ContractNegotiation mapContractNegotiation(ResultSet resultSet, ResultSetMapper<ContractAgreement> agreementMapper) throws Exception {
        return ((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)((ContractNegotiation.Builder)ContractNegotiation.Builder.newInstance().id(resultSet.getString(this.statements.getIdColumn()))).counterPartyId(resultSet.getString(this.statements.getCounterPartyIdColumn())).counterPartyAddress(resultSet.getString(this.statements.getCounterPartyAddressColumn())).protocol(resultSet.getString(this.statements.getProtocolColumn())).correlationId(resultSet.getString(this.statements.getCorrelationIdColumn())).contractAgreement((ContractAgreement)agreementMapper.mapResultSet(resultSet)).state(resultSet.getInt(this.statements.getStateColumn()))).stateCount(resultSet.getInt(this.statements.getStateCountColumn()))).stateTimestamp(resultSet.getLong(this.statements.getStateTimestampColumn()))).contractOffers((List)this.fromJson(resultSet.getString(this.statements.getContractOffersColumn()), (TypeReference)new TypeReference<List<ContractOffer>>(){})).callbackAddresses((List)this.fromJson(resultSet.getString(this.statements.getCallbackAddressesColumn()), (TypeReference)new TypeReference<List<CallbackAddress>>(){})).errorDetail(resultSet.getString(this.statements.getErrorDetailColumn()))).traceContext((Map)this.fromJson(resultSet.getString(this.statements.getTraceContextColumn()), (TypeReference)new TypeReference<Map<String, String>>(){}))).type(ContractNegotiation.Type.valueOf((String)resultSet.getString(this.statements.getTypeColumn()))).createdAt(resultSet.getLong(this.statements.getCreatedAtColumn()))).updatedAt(resultSet.getLong(this.statements.getUpdatedAtColumn()))).pending(resultSet.getBoolean(this.statements.getPendingColumn()))).build();
    }

    private ContractAgreement extractContractAgreement(ResultSet resultSet) throws SQLException {
        return resultSet.getString(this.statements.getContractAgreementIdFkColumn()) == null ? null : this.mapContractAgreement(resultSet);
    }
}

