/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.store.sql.contractnegotiation;

import java.time.Clock;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.store.sql.contractnegotiation.store.SqlContractNegotiationStore;
import org.eclipse.edc.connector.store.sql.contractnegotiation.store.schema.ContractNegotiationStatements;
import org.eclipse.edc.connector.store.sql.contractnegotiation.store.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Provides(value={ContractNegotiationStore.class})
@Extension(value="SQL contract negotiation store")
public class SqlContractNegotiationStoreExtension
implements ServiceExtension {
    public static final String DATASOURCE_NAME_SETTING = "edc.datasource.contractnegotiation.name";
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext trxContext;
    @Inject
    private Clock clock;
    @Inject(required=false)
    private ContractNegotiationStatements statements;
    @Inject
    private TypeManager typeManager;
    @Inject
    private QueryExecutor queryExecutor;

    public void initialize(ServiceExtensionContext context) {
        SqlContractNegotiationStore sqlStore = new SqlContractNegotiationStore(this.dataSourceRegistry, this.getDataSourceName(context), this.trxContext, this.typeManager.getMapper(), this.getStatementImpl(), context.getConnectorId(), this.clock, this.queryExecutor);
        context.registerService(ContractNegotiationStore.class, (Object)sqlStore);
    }

    private ContractNegotiationStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDialectStatements();
    }

    private String getDataSourceName(ServiceExtensionContext context) {
        return context.getConfig().getString(DATASOURCE_NAME_SETTING, "default");
    }
}

