/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.v3;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.BaseContractNegotiationApiController;
import org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.v3.ContractNegotiationApiV3;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v3/contractnegotiations")
public class ContractNegotiationApiV3Controller
extends BaseContractNegotiationApiController
implements ContractNegotiationApiV3 {
    public ContractNegotiationApiV3Controller(ContractNegotiationService service, TypeTransformerRegistry transformerRegistry, Monitor monitor, JsonObjectValidatorRegistry validatorRegistry) {
        super(service, transformerRegistry, monitor, validatorRegistry);
    }

    @Override
    @POST
    @Path(value="/request")
    public JsonArray queryNegotiationsV3(JsonObject querySpecJson) {
        return this.queryNegotiations(querySpecJson);
    }

    @Override
    @GET
    @Path(value="/{id}")
    public JsonObject getNegotiationV3(@PathParam(value="id") String id) {
        return this.getNegotiation(id);
    }

    @Override
    @GET
    @Path(value="/{id}/state")
    public JsonObject getNegotiationStateV3(@PathParam(value="id") String id) {
        return this.getNegotiationState(id);
    }

    @Override
    @GET
    @Path(value="/{id}/agreement")
    public JsonObject getAgreementForNegotiationV3(@PathParam(value="id") String negotiationId) {
        return this.getAgreementForNegotiation(negotiationId);
    }

    @Override
    @POST
    public JsonObject initiateContractNegotiationV3(JsonObject requestObject) {
        return this.initiateContractNegotiation(requestObject);
    }

    @Override
    @POST
    @Path(value="/{id}/terminate")
    public void terminateNegotiationV3(@PathParam(value="id") String id, JsonObject terminateNegotiation) {
        this.terminateNegotiation(id, terminateNegotiation);
    }
}

