/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.v2;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.List;
import org.eclipse.edc.api.management.schema.ManagementApiSchema;
import org.eclipse.edc.api.model.ApiCoreSchema;
import org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.model.NegotiationState;

@OpenAPIDefinition(info=@Info(version="v2"))
@Tag(name="Contract Negotiation V2")
public interface ContractNegotiationApiV2 {
    @Operation(description="Returns all contract negotiations according to a query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The contract negotiations that match the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ManagementApiSchema.ContractNegotiationSchema.class)))}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})}, deprecated=true)
    @Deprecated(since="0.7.0")
    public JsonArray queryNegotiationsV2(JsonObject var1);

    @Operation(description="Gets a contract negotiation with the given ID", responses={@ApiResponse(responseCode="200", description="The contract negotiation", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractNegotiationSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})}, deprecated=true)
    @Deprecated(since="0.7.0")
    public JsonObject getNegotiationV2(String var1);

    @Operation(description="Gets the state of a contract negotiation with the given ID", responses={@ApiResponse(responseCode="200", description="The contract negotiation's state", content={@Content(schema=@Schema(implementation=NegotiationState.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})}, deprecated=true)
    @Deprecated(since="0.7.0")
    public JsonObject getNegotiationStateV2(String var1);

    @Operation(description="Gets a contract agreement for a contract negotiation with the given ID", responses={@ApiResponse(responseCode="200", description="The contract agreement that is attached to the negotiation, or null", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractAgreementSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})}, deprecated=true)
    @Deprecated(since="0.7.0")
    public JsonObject getAgreementForNegotiationV2(String var1);

    @Operation(description="Initiates a contract negotiation for a given offer and with the given counter part. Please note that successfully invoking this endpoint only means that the negotiation was initiated. Clients must poll the /{id}/state endpoint to track the state", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ContractRequestSchema.class))}), responses={@ApiResponse(responseCode="200", description="The negotiation was successfully initiated. Returns the contract negotiation ID and created timestamp", content={@Content(schema=@Schema(implementation=ApiCoreSchema.IdResponseSchema.class))}, links={@Link(name="poll-state", operationId="getNegotiationStateV2", parameters={@LinkParameter(name="id", expression="$response.body#/id")})}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})}, deprecated=true)
    @Deprecated(since="0.7.0")
    public JsonObject initiateContractNegotiationV2(JsonObject var1);

    @Operation(description="Terminates the contract negotiation.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=TerminateNegotiationSchema.class))}), responses={@ApiResponse(responseCode="200", description="ContractNegotiation is terminating", links={@Link(name="poll-state", operationId="getNegotiationStateV2")}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})}, deprecated=true)
    @Deprecated(since="0.7.0")
    public void terminateNegotiationV2(String var1, JsonObject var2);

    @Schema(example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"reason\": \"a reason to terminate\"\n}\n")
    public record TerminateNegotiationSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation") String ldType, @Schema(name="@id") String id, String reason) {
        public static final String TERMINATE_NEGOTIATION_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"reason\": \"a reason to terminate\"\n}\n";
    }

    @Schema(name="Offer", description="ODRL offer", example="{\n    \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n    \"@type\": \"odrl:Offer\",\n    \"@id\": \"offer-id\",\n    \"assigner\": \"providerId\",\n    \"target\": \"assetId\",\n    \"permission\": [],\n    \"prohibition\": [],\n    \"obligation\": []\n}\n")
    public record OfferSchema(@Schema(name="@type", example="http://www.w3.org/ns/odrl/2/Offer") String type, @Schema(name="@id", requiredMode=Schema.RequiredMode.REQUIRED) String id, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String assigner, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String target) {
        public static final String OFFER_EXAMPLE = "{\n    \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n    \"@type\": \"odrl:Offer\",\n    \"@id\": \"offer-id\",\n    \"assigner\": \"providerId\",\n    \"target\": \"assetId\",\n    \"permission\": [],\n    \"prohibition\": [],\n    \"obligation\": []\n}\n";
    }

    @Schema(name="ContractRequest", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractRequest\",\n    \"counterPartyAddress\": \"http://provider-address\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"policy\": {\n        \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n        \"@type\": \"odrl:Offer\",\n        \"@id\": \"offer-id\",\n        \"assigner\": \"providerId\",\n        \"permission\": [],\n        \"prohibition\": [],\n        \"obligation\": [],\n        \"target\": \"assetId\"\n    },\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n")
    public record ContractRequestSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractRequest") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String protocol, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String counterPartyAddress, @Schema(deprecated=true, description="please use policy.assigner instead") String providerId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) OfferSchema policy, List<ManagementApiSchema.CallbackAddressSchema> callbackAddresses) {
        public static final String CONTRACT_REQUEST_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractRequest\",\n    \"counterPartyAddress\": \"http://provider-address\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"policy\": {\n        \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n        \"@type\": \"odrl:Offer\",\n        \"@id\": \"offer-id\",\n        \"assigner\": \"providerId\",\n        \"permission\": [],\n        \"prohibition\": [],\n        \"obligation\": [],\n        \"target\": \"assetId\"\n    },\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n";
    }
}

