/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation.validation;

import jakarta.json.JsonObject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.jsonobject.JsonObjectValidator;
import org.eclipse.edc.validator.jsonobject.validators.LogDeprecatedValue;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryIdNotBlank;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryObject;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryValue;
import org.eclipse.edc.validator.jsonobject.validators.TypeIs;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;

public class ContractRequestValidator {
    public static Validator<JsonObject> instance(Monitor monitor) {
        return JsonObjectValidator.newValidator().verify(path -> new LogDeprecatedValue(path.append("https://w3id.org/edc/v0.0.1/ns/providerId"), "https://w3id.org/edc/v0.0.1/ns/ContractRequest", "http://www.w3.org/ns/odrl/2/assigner", monitor)).verify(path -> new LogDeprecatedValue(path.append("https://w3id.org/edc/v0.0.1/ns/offer"), "https://w3id.org/edc/v0.0.1/ns/ContractRequest", "https://w3id.org/edc/v0.0.1/ns/policy", monitor)).verify(path -> new LogDeprecatedValue(path.append("https://w3id.org/edc/v0.0.1/ns/connectorAddress"), "https://w3id.org/edc/v0.0.1/ns/ContractRequest", "https://w3id.org/edc/v0.0.1/ns/counterPartyAddress", monitor)).verify(path -> new MandatoryCounterPartyAddressOrConnectorAddress((JsonLdPath)path, monitor)).verify("https://w3id.org/edc/v0.0.1/ns/protocol", MandatoryValue::new).verify(path -> new MandatoryOfferOrPolicy((JsonLdPath)path, monitor)).build();
    }

    private record MandatoryOfferOrPolicy(JsonLdPath path, Monitor monitor) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            ValidationResult offerValidity = new MandatoryObject(this.path.append("https://w3id.org/edc/v0.0.1/ns/offer")).validate(input);
            if (offerValidity.succeeded()) {
                return JsonObjectValidator.newValidator().verifyObject("https://w3id.org/edc/v0.0.1/ns/offer", v -> v.verify("https://w3id.org/edc/v0.0.1/ns/offerId", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/assetId", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/policy", MandatoryObject::new)).build().validate(input);
            }
            JsonObjectValidator validator = JsonObjectValidator.newValidator().verify("https://w3id.org/edc/v0.0.1/ns/policy", MandatoryObject::new).verifyObject("https://w3id.org/edc/v0.0.1/ns/policy", builder -> builder.verifyId(MandatoryIdNotBlank::new).verify(path -> new TypeIs(path, "http://www.w3.org/ns/odrl/2/Offer")).verify("http://www.w3.org/ns/odrl/2/assigner", MandatoryObject::new).verifyObject("http://www.w3.org/ns/odrl/2/assigner", b -> b.verifyId(MandatoryIdNotBlank::new)).verify("http://www.w3.org/ns/odrl/2/target", MandatoryObject::new).verifyObject("http://www.w3.org/ns/odrl/2/target", b -> b.verifyId(MandatoryIdNotBlank::new))).build();
            return validator.validate(input);
        }
    }

    private record MandatoryCounterPartyAddressOrConnectorAddress(JsonLdPath path, Monitor monitor) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            MandatoryValue counterPartyAddress = new MandatoryValue(this.path.append("https://w3id.org/edc/v0.0.1/ns/counterPartyAddress"));
            ValidationResult validateCounterParty = counterPartyAddress.validate(input);
            if (validateCounterParty.succeeded()) {
                return ValidationResult.success();
            }
            MandatoryValue connectorAddress = new MandatoryValue(this.path.append("https://w3id.org/edc/v0.0.1/ns/connectorAddress"));
            ValidationResult validateConnectorAddress = connectorAddress.validate(input);
            if (validateConnectorAddress.succeeded()) {
                return ValidationResult.success();
            }
            return validateCounterParty;
        }
    }
}

