/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation.transform;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.api.management.contractnegotiation.model.ContractOfferDescription;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.spi.types.domain.offer.ContractOffer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractRequestTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractRequest> {
    public JsonObjectToContractRequestTransformer() {
        super(JsonObject.class, ContractRequest.class);
    }

    @Nullable
    public ContractRequest transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        ContractRequest.Builder contractRequestBuilder = ContractRequest.Builder.newInstance().counterPartyAddress(this.counterPartyAddressOrConnectorAddress(jsonObject, context)).protocol(this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/protocol"), context));
        contractRequestBuilder.contractOffer(this.contractOffer(jsonObject, context));
        JsonValue callbackAddress = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/callbackAddresses");
        if (callbackAddress != null) {
            contractRequestBuilder.callbackAddresses(this.transformArray(callbackAddress, CallbackAddress.class, context));
        }
        return contractRequestBuilder.build();
    }

    private ContractOffer contractOffer(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        JsonValue policy = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/policy");
        if (policy != null) {
            return (ContractOffer)this.transformObject(policy, ContractOffer.class, context);
        }
        JsonValue offerJson = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/offer");
        if (offerJson != null) {
            ContractOfferDescription contractOfferDescription = (ContractOfferDescription)this.transformObject((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/offer"), ContractOfferDescription.class, context);
            return ContractOffer.Builder.newInstance().id(contractOfferDescription.getOfferId()).assetId(contractOfferDescription.getAssetId()).policy(contractOfferDescription.getPolicy()).build();
        }
        return null;
    }

    private String counterPartyAddressOrConnectorAddress(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        String counterPartyAddress = this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/counterPartyAddress"), context);
        return counterPartyAddress != null ? counterPartyAddress : this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/connectorAddress"), context);
    }
}

