/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation.transform;

import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import java.util.Optional;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.agreement.ContractAgreement;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractNegotiationTransformer
extends AbstractJsonLdTransformer<ContractNegotiation, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractNegotiationTransformer(JsonBuilderFactory jsonFactory) {
        super(ContractNegotiation.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractNegotiation contractNegotiation, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        JsonArray callbackAddresses = (JsonArray)contractNegotiation.getCallbackAddresses().stream().map(callbackAddress -> (JsonObject)context.transform(callbackAddress, JsonObject.class)).collect(JsonCollectors.toJsonArray());
        builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/ContractNegotiation").add("@id", contractNegotiation.getId()).add("https://w3id.org/edc/v0.0.1/ns/type", contractNegotiation.getType().toString()).add("https://w3id.org/edc/v0.0.1/ns/protocol", contractNegotiation.getProtocol()).add("https://w3id.org/edc/v0.0.1/ns/state", ContractNegotiationStates.from((int)contractNegotiation.getState()).name()).add("https://w3id.org/edc/v0.0.1/ns/counterPartyId", contractNegotiation.getCounterPartyId()).add("https://w3id.org/edc/v0.0.1/ns/counterPartyAddress", contractNegotiation.getCounterPartyAddress()).add("https://w3id.org/edc/v0.0.1/ns/callbackAddresses", (JsonValue)callbackAddresses).add("https://w3id.org/edc/v0.0.1/ns/createdAt", contractNegotiation.getCreatedAt());
        Optional.ofNullable(contractNegotiation.getContractAgreement()).map(ContractAgreement::getId).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/contractAgreementId", s));
        Optional.ofNullable(contractNegotiation.getErrorDetail()).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/errorDetail", s));
        return builder.build();
    }
}

