/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.api.management.contractnegotiation.ContractNegotiationApi;
import org.eclipse.edc.connector.api.management.contractnegotiation.model.NegotiationState;
import org.eclipse.edc.connector.contract.spi.types.command.TerminateNegotiationCommand;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v2/contractnegotiations")
public class ContractNegotiationApiController
implements ContractNegotiationApi {
    private final ContractNegotiationService service;
    private final TypeTransformerRegistry transformerRegistry;
    private final Monitor monitor;
    private final JsonObjectValidatorRegistry validatorRegistry;

    public ContractNegotiationApiController(ContractNegotiationService service, TypeTransformerRegistry transformerRegistry, Monitor monitor, JsonObjectValidatorRegistry validatorRegistry) {
        this.service = service;
        this.transformerRegistry = transformerRegistry;
        this.monitor = monitor;
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    @POST
    @Path(value="/request")
    public JsonArray queryNegotiations(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        try (Stream stream = (Stream)this.service.query(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractNegotiation.class, null));){
            JsonArray jsonArray = (JsonArray)stream.map(it -> this.transformerRegistry.transform(it, JsonObject.class)).peek(this::logIfError).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
            return jsonArray;
        }
    }

    @Override
    @GET
    @Path(value="/{id}")
    public JsonObject getNegotiation(@PathParam(value="id") String id) {
        return Optional.of(id).map(arg_0 -> ((ContractNegotiationService)this.service).findbyId(arg_0)).map(it -> this.transformerRegistry.transform(it, JsonObject.class)).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(ContractNegotiation.class, id));
    }

    @Override
    @GET
    @Path(value="/{id}/state")
    public JsonObject getNegotiationState(@PathParam(value="id") String id) {
        return (JsonObject)Optional.of(id).map(arg_0 -> ((ContractNegotiationService)this.service).getState(arg_0)).map(NegotiationState::new).map(state -> this.transformerRegistry.transform(state, JsonObject.class)).orElseThrow(() -> new ObjectNotFoundException(ContractNegotiation.class, id)).orElseThrow(failure -> new EdcException(failure.getFailureDetail()));
    }

    @Override
    @GET
    @Path(value="/{id}/agreement")
    public JsonObject getAgreementForNegotiation(@PathParam(value="id") String negotiationId) {
        return Optional.of(negotiationId).map(arg_0 -> ((ContractNegotiationService)this.service).getForNegotiation(arg_0)).map(it -> (JsonObject)this.transformerRegistry.transform(it, JsonObject.class).orElseThrow(failure -> new EdcException(failure.getFailureDetail()))).orElseThrow(() -> new ObjectNotFoundException(ContractNegotiation.class, negotiationId));
    }

    @Override
    @POST
    public JsonObject initiateContractNegotiation(JsonObject requestObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ContractRequest", requestObject).orElseThrow(ValidationFailureException::new);
        ContractRequest contractRequest = (ContractRequest)this.transformerRegistry.transform((Object)requestObject, ContractRequest.class).orElseThrow(InvalidRequestException::new);
        ContractNegotiation contractNegotiation = this.service.initiateNegotiation(contractRequest);
        IdResponse responseDto = IdResponse.Builder.newInstance().id(contractNegotiation.getId()).createdAt(contractNegotiation.getCreatedAt()).build();
        return (JsonObject)this.transformerRegistry.transform((Object)responseDto, JsonObject.class).orElseThrow(f -> new EdcException("Error creating response body: " + f.getFailureDetail()));
    }

    @Override
    @POST
    @Path(value="/{id}/terminate")
    public void terminateNegotiation(@PathParam(value="id") String id, JsonObject terminateNegotiation) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation", terminateNegotiation).orElseThrow(ValidationFailureException::new);
        TerminateNegotiationCommand command = (TerminateNegotiationCommand)this.transformerRegistry.transform((Object)terminateNegotiation, TerminateNegotiationCommand.class).orElseThrow(InvalidRequestException::new);
        this.service.terminate(command).orElseThrow(ServiceResultHandler.exceptionMapper(ContractNegotiation.class, (String)id));
    }

    private void logIfError(Result<?> result) {
        result.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]));
    }
}

