/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation.transform;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import org.eclipse.edc.connector.api.management.contractnegotiation.model.ContractOfferDescription;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractRequestTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractRequest> {
    public JsonObjectToContractRequestTransformer() {
        super(JsonObject.class, ContractRequest.class);
    }

    @Nullable
    public ContractRequest transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        ContractRequest.Builder contractRequestBuilder = ContractRequest.Builder.newInstance().providerId(this.getProviderId(jsonObject, context)).counterPartyAddress(this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/connectorAddress"), context)).protocol(this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/protocol"), context));
        ContractOfferDescription contractOfferDescription = (ContractOfferDescription)this.transformObject((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/offer"), ContractOfferDescription.class, context);
        ContractOffer contractOffer = ContractOffer.Builder.newInstance().id(contractOfferDescription.getOfferId()).assetId(contractOfferDescription.getAssetId()).policy(contractOfferDescription.getPolicy()).build();
        contractRequestBuilder.contractOffer(contractOffer);
        JsonValue callbackAddress = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/callbackAddresses");
        if (callbackAddress != null) {
            ArrayList addresses = new ArrayList();
            this.transformArrayOrObject(callbackAddress, CallbackAddress.class, addresses::add, context);
            contractRequestBuilder.callbackAddresses(addresses);
        }
        return contractRequestBuilder.build();
    }

    private String getProviderId(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        JsonValue providerId = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/providerId");
        if (providerId != null) {
            return this.transformString(providerId, context);
        }
        JsonValue connectorId = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/connectorId");
        if (connectorId != null) {
            return this.transformString(connectorId, context);
        }
        return this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/connectorAddress"), context);
    }
}

