/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiConfiguration;
import org.eclipse.edc.connector.api.management.configuration.transform.ManagementApiTypeTransformerRegistry;
import org.eclipse.edc.connector.api.management.contractnegotiation.ContractNegotiationApiController;
import org.eclipse.edc.connector.api.management.contractnegotiation.transform.JsonObjectFromContractNegotiationTransformer;
import org.eclipse.edc.connector.api.management.contractnegotiation.transform.JsonObjectFromNegotiationStateTransformer;
import org.eclipse.edc.connector.api.management.contractnegotiation.transform.JsonObjectToContractOfferDescriptionTransformer;
import org.eclipse.edc.connector.api.management.contractnegotiation.transform.JsonObjectToContractRequestTransformer;
import org.eclipse.edc.connector.api.management.contractnegotiation.transform.JsonObjectToTerminateNegotiationCommandTransformer;
import org.eclipse.edc.connector.api.management.contractnegotiation.validation.ContractRequestValidator;
import org.eclipse.edc.connector.api.management.contractnegotiation.validation.TerminateNegotiationValidator;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Management API: Contract Negotiation")
public class ContractNegotiationApiExtension
implements ServiceExtension {
    public static final String NAME = "Management API: Contract Negotiation";
    @Inject
    private WebService webService;
    @Inject
    private ManagementApiConfiguration config;
    @Inject
    private ManagementApiTypeTransformerRegistry transformerRegistry;
    @Inject
    private ContractNegotiationService service;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory factory = Json.createBuilderFactory(Map.of());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToContractRequestTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToContractOfferDescriptionTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToTerminateNegotiationCommandTransformer());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTransformer(factory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromNegotiationStateTransformer(factory));
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/ContractRequest", ContractRequestValidator.instance());
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation", TerminateNegotiationValidator.instance());
        Monitor monitor = context.getMonitor();
        ContractNegotiationApiController controller = new ContractNegotiationApiController(this.service, (TypeTransformerRegistry)this.transformerRegistry, monitor, this.validatorRegistry);
        this.webService.registerResource(this.config.getContextAlias(), (Object)controller);
    }
}

