/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractnegotiation;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.List;
import org.eclipse.edc.api.model.ApiCoreSchema;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiSchema;
import org.eclipse.edc.connector.api.management.contractnegotiation.model.NegotiationState;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.web.spi.ApiErrorDetail;

@OpenAPIDefinition
@Tag(name="Contract Negotiation")
public interface ContractNegotiationApi {
    @Operation(description="Returns all contract negotiations according to a query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The contract negotiations that match the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ContractNegotiationSchema.class)))}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public JsonArray queryNegotiations(JsonObject var1);

    @Operation(description="Gets a contract negotiation with the given ID", responses={@ApiResponse(responseCode="200", description="The contract negotiation", content={@Content(schema=@Schema(implementation=ContractNegotiationSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="An contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public JsonObject getNegotiation(String var1);

    @Operation(description="Gets the state of a contract negotiation with the given ID", operationId="getNegotiationState", responses={@ApiResponse(responseCode="200", description="The contract negotiation's state", content={@Content(schema=@Schema(implementation=NegotiationState.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="An contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public JsonObject getNegotiationState(String var1);

    @Operation(description="Gets a contract agreement for a contract negotiation with the given ID", responses={@ApiResponse(responseCode="200", description="The contract agreement that is attached to the negotiation, or null", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractAgreementSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="An contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public JsonObject getAgreementForNegotiation(String var1);

    @Operation(description="Initiates a contract negotiation for a given offer and with the given counter part. Please note that successfully invoking this endpoint only means that the negotiation was initiated. Clients must poll the /{id}/state endpoint to track the state", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ContractRequestSchema.class))}), responses={@ApiResponse(responseCode="200", description="The negotiation was successfully initiated. Returns the contract negotiation ID and created timestamp", content={@Content(schema=@Schema(implementation=ApiCoreSchema.IdResponseSchema.class))}, links={@Link(name="poll-state", operationId="getNegotiationState", parameters={@LinkParameter(name="id", expression="$response.body#/id")})}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public JsonObject initiateContractNegotiation(JsonObject var1);

    @Operation(description="Terminates the contract negotiation.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=TerminateNegotiationSchema.class))}), responses={@ApiResponse(responseCode="200", description="ContractNegotiation is terminating", links={@Link(name="poll-state", operationId="getNegotiationState")}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="A contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public void terminateNegotiation(String var1, JsonObject var2);

    @Operation(description="Requests aborting the contract negotiation. Due to the asynchronous nature of contract negotiations, a successful response only indicates that the request was successfully received. Clients must poll the /{id}/state endpoint to track the state.", responses={@ApiResponse(responseCode="200", description="Request to cancel the Contract negotiation was successfully received", links={@Link(name="poll-state", operationId="getNegotiationState")}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="A contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    @Deprecated(since="0.1.3")
    public void cancelNegotiation(String var1);

    @Operation(description="Requests cancelling the contract negotiation. Due to the asynchronous nature of contract negotiations, a successful response only indicates that the request was successfully received. Clients must poll the /{id}/state endpoint to track the state.", responses={@ApiResponse(responseCode="200", description="Request to decline the Contract negotiation was successfully received", links={@Link(name="poll-state", operationId="getNegotiationState")}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="A contract negotiation with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    @Deprecated(since="0.1.3")
    public void declineNegotiation(String var1);

    @Schema(example="{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"reason\": \"a reason to terminate\"\n}\n")
    public record TerminateNegotiationSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation") String ldType, @Schema(name="@id") String id, String reason) {
        public static final String TERMINATE_NEGOTIATION_EXAMPLE = "{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"reason\": \"a reason to terminate\"\n}\n";
    }

    @Schema(name="ContractOfferDescription")
    public record ContractOfferDescriptionSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractOfferDescription") String type, String offerId, String assetId, ManagementApiSchema.PolicySchema policy) {
    }

    @Schema(name="NegotiationState", example="{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/NegotiationState\",\n    \"state\": \"REQUESTED\"\n}\n")
    public record NegotiationStateSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/NegotiationState") String ldType, String state) {
        public static final String NEGOTIATION_STATE_EXAMPLE = "{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/NegotiationState\",\n    \"state\": \"REQUESTED\"\n}\n";
    }

    @Schema(name="ContractNegotiation", example="{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"type\": \"PROVIDER\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"counterPartyId\": \"counter-party-id\",\n    \"counterPartyAddress\": \"http://counter/party/address\",\n    \"state\": \"VERIFIED\",\n    \"contractAgreementId\": \"contract:agreement:id\",\n    \"errorDetail\": \"eventual-error-detail\",\n    \"createdAt\": 1688465655,\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n")
    public record ContractNegotiationSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractNegotiation") String ldType, @Schema(name="@id") String id, ContractNegotiation.Type type, String protocol, String counterPartyId, String counterPartyAddress, String state, String contractAgreementId, String errorDetail, List<ManagementApiSchema.CallbackAddressSchema> callbackAddresses) {
        public static final String CONTRACT_NEGOTIATION_EXAMPLE = "{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractNegotiation\",\n    \"@id\": \"negotiation-id\",\n    \"type\": \"PROVIDER\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"counterPartyId\": \"counter-party-id\",\n    \"counterPartyAddress\": \"http://counter/party/address\",\n    \"state\": \"VERIFIED\",\n    \"contractAgreementId\": \"contract:agreement:id\",\n    \"errorDetail\": \"eventual-error-detail\",\n    \"createdAt\": 1688465655,\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n";
    }

    @Schema(name="ContractRequest", example="{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractRequest\",\n    \"connectorAddress\": \"http://provider-address\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"providerId\": \"provider-id\",\n    \"offer\": {\n        \"offerId\": \"offer-id\",\n        \"assetId\": \"asset-id\",\n        \"policy\": {\n            \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n            \"@type\": \"Set\",\n            \"@id\": \"offer-id\",\n            \"permission\": [{\n                \"target\": \"asset-id\",\n                \"action\": \"display\"\n            }]\n        }\n    },\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n")
    public record ContractRequestSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractRequest") String type, String protocol, String connectorAddress, @Deprecated(since="0.1.3") @Schema(deprecated=true, description="please use providerId instead") String connectorId, @Deprecated(since="0.1.3") @Schema(deprecated=true, description="this field is not used anymore") String consumerId, String providerId, ContractOfferDescriptionSchema offer, List<ManagementApiSchema.CallbackAddressSchema> callbackAddresses) {
        public static final String CONTRACT_REQUEST_EXAMPLE = "{\n    \"@context\": { \"edc\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/ContractRequest\",\n    \"connectorAddress\": \"http://provider-address\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"providerId\": \"provider-id\",\n    \"offer\": {\n        \"offerId\": \"offer-id\",\n        \"assetId\": \"asset-id\",\n        \"policy\": {\n            \"@context\": \"http://www.w3.org/ns/odrl.jsonld\",\n            \"@type\": \"Set\",\n            \"@id\": \"offer-id\",\n            \"permission\": [{\n                \"target\": \"asset-id\",\n                \"action\": \"display\"\n            }]\n        }\n    },\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n";
    }
}

