/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.transform;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractRequestTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractRequest> {
    public JsonObjectToContractRequestTransformer() {
        super(JsonObject.class, ContractRequest.class);
    }

    @Nullable
    public ContractRequest transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        ContractRequest.Builder contractRequestBuilder = ContractRequest.Builder.newInstance().counterPartyAddress(this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/counterPartyAddress"), context)).protocol(this.transformString((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/protocol"), context));
        contractRequestBuilder.contractOffer(this.contractOffer(jsonObject, context));
        JsonValue callbackAddress = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/callbackAddresses");
        if (callbackAddress != null) {
            contractRequestBuilder.callbackAddresses(this.transformArray(callbackAddress, CallbackAddress.class, context));
        }
        return contractRequestBuilder.build();
    }

    private ContractOffer contractOffer(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        JsonValue policy = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/policy");
        if (policy != null) {
            return (ContractOffer)this.transformObject(policy, ContractOffer.class, context);
        }
        return null;
    }
}

