/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractnegotiation;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.controlplane.api.management.contractnegotiation.model.NegotiationState;
import org.eclipse.edc.connector.controlplane.contract.spi.types.command.TerminateNegotiationCommand;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.connector.controlplane.services.spi.contractnegotiation.ContractNegotiationService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

public class BaseContractNegotiationApiController {
    protected final ContractNegotiationService service;
    protected final TypeTransformerRegistry transformerRegistry;
    protected final Monitor monitor;
    protected final JsonObjectValidatorRegistry validatorRegistry;

    public BaseContractNegotiationApiController(ContractNegotiationService service, TypeTransformerRegistry transformerRegistry, Monitor monitor, JsonObjectValidatorRegistry validatorRegistry) {
        this.service = service;
        this.transformerRegistry = transformerRegistry;
        this.monitor = monitor;
        this.validatorRegistry = validatorRegistry;
    }

    public JsonArray queryNegotiations(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        return (JsonArray)((List)this.service.search(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractNegotiation.class, null))).stream().map(it -> this.transformerRegistry.transform(it, JsonObject.class)).peek(this::logIfError).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    public JsonObject getNegotiation(String id) {
        return Optional.of(id).map(arg_0 -> ((ContractNegotiationService)this.service).findbyId(arg_0)).map(it -> this.transformerRegistry.transform(it, JsonObject.class)).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(ContractNegotiation.class, id));
    }

    public JsonObject getNegotiationState(String id) {
        return (JsonObject)Optional.of(id).map(arg_0 -> ((ContractNegotiationService)this.service).getState(arg_0)).map(NegotiationState::new).map(state -> this.transformerRegistry.transform(state, JsonObject.class)).orElseThrow(() -> new ObjectNotFoundException(ContractNegotiation.class, id)).orElseThrow(failure -> new EdcException(failure.getFailureDetail()));
    }

    public JsonObject getAgreementForNegotiation(String negotiationId) {
        return Optional.of(negotiationId).map(arg_0 -> ((ContractNegotiationService)this.service).getForNegotiation(arg_0)).map(it -> (JsonObject)this.transformerRegistry.transform(it, JsonObject.class).orElseThrow(failure -> new EdcException(failure.getFailureDetail()))).orElseThrow(() -> new ObjectNotFoundException(ContractNegotiation.class, negotiationId));
    }

    public JsonObject initiateContractNegotiation(JsonObject requestObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ContractRequest", requestObject).orElseThrow(ValidationFailureException::new);
        ContractRequest contractRequest = (ContractRequest)this.transformerRegistry.transform((Object)requestObject, ContractRequest.class).orElseThrow(InvalidRequestException::new);
        ContractNegotiation contractNegotiation = this.service.initiateNegotiation(contractRequest);
        IdResponse responseDto = IdResponse.Builder.newInstance().id(contractNegotiation.getId()).createdAt(contractNegotiation.getCreatedAt()).build();
        return (JsonObject)this.transformerRegistry.transform((Object)responseDto, JsonObject.class).orElseThrow(f -> new EdcException("Error creating response body: " + f.getFailureDetail()));
    }

    public void terminateNegotiation(String id, JsonObject terminateNegotiation) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/TerminateNegotiation", terminateNegotiation).orElseThrow(ValidationFailureException::new);
        TerminateNegotiationCommand command = (TerminateNegotiationCommand)this.transformerRegistry.transform((Object)terminateNegotiation, TerminateNegotiationCommand.class).orElseThrow(InvalidRequestException::new);
        this.service.terminate(command).orElseThrow(ServiceResultHandler.exceptionMapper(ContractNegotiation.class, (String)id));
    }

    private void logIfError(Result<?> result) {
        result.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]));
    }
}

