/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiConfiguration;
import org.eclipse.edc.connector.api.management.configuration.transform.ManagementApiTypeTransformerRegistry;
import org.eclipse.edc.connector.api.management.contractdefinition.ContractDefinitionApiController;
import org.eclipse.edc.connector.api.management.contractdefinition.transform.JsonObjectFromContractDefinitionTransformer;
import org.eclipse.edc.connector.api.management.contractdefinition.transform.JsonObjectToContractDefinitionTransformer;
import org.eclipse.edc.connector.api.management.contractdefinition.validation.ContractDefinitionValidator;
import org.eclipse.edc.connector.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Management API: Contract Definition")
public class ContractDefinitionApiExtension
implements ServiceExtension {
    public static final String NAME = "Management API: Contract Definition";
    @Inject
    WebService webService;
    @Inject
    ManagementApiConfiguration config;
    @Inject
    ManagementApiTypeTransformerRegistry transformerRegistry;
    @Inject
    ContractDefinitionService service;
    @Inject
    JsonObjectValidatorRegistry validatorRegistry;
    @Inject
    private TypeManager typeManager;
    @Inject
    private CriterionOperatorRegistry criterionOperatorRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory jsonFactory = Json.createBuilderFactory(Map.of());
        ObjectMapper mapper = this.typeManager.getMapper("json-ld");
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromContractDefinitionTransformer(jsonFactory, mapper));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectToContractDefinitionTransformer());
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/ContractDefinition", (Validator)ContractDefinitionValidator.instance(this.criterionOperatorRegistry));
        Monitor monitor = context.getMonitor();
        this.webService.registerResource(this.config.getContextAlias(), (Object)new ContractDefinitionApiController((TypeTransformerRegistry)this.transformerRegistry, this.service, monitor, this.validatorRegistry));
    }
}

