/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.api.management.contractdefinition.ContractDefinitionApi;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Produces(value={"application/json"})
@Path(value="/v2/contractdefinitions")
public class ContractDefinitionApiController
implements ContractDefinitionApi {
    private final TypeTransformerRegistry transformerRegistry;
    private final ContractDefinitionService service;
    private final Monitor monitor;
    private final JsonObjectValidatorRegistry validatorRegistry;

    public ContractDefinitionApiController(TypeTransformerRegistry transformerRegistry, ContractDefinitionService service, Monitor monitor, JsonObjectValidatorRegistry validatorRegistry) {
        this.transformerRegistry = transformerRegistry;
        this.service = service;
        this.monitor = monitor;
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    @POST
    @Path(value="/request")
    public JsonArray queryAllContractDefinitions(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        return (JsonArray)((List)this.service.search(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class))).stream().map(contractDefinition -> this.transformerRegistry.transform(contractDefinition, JsonObject.class)).peek(r -> r.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    @Override
    @GET
    @Path(value="{id}")
    public JsonObject getContractDefinition(@PathParam(value="id") String id) {
        return Optional.ofNullable(id).map(arg_0 -> ((ContractDefinitionService)this.service).findById(arg_0)).map(it -> this.transformerRegistry.transform(it, JsonObject.class)).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(ContractDefinition.class, id));
    }

    @Override
    @POST
    public JsonObject createContractDefinition(JsonObject createObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ContractDefinition", createObject).orElseThrow(ValidationFailureException::new);
        ContractDefinition transform = (ContractDefinition)this.transformerRegistry.transform((Object)createObject, ContractDefinition.class).orElseThrow(InvalidRequestException::new);
        IdResponse responseDto = (IdResponse)this.service.create(transform).map(contractDefinition -> IdResponse.Builder.newInstance().id(contractDefinition.getId()).createdAt(contractDefinition.getCreatedAt()).build()).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class));
        return (JsonObject)this.transformerRegistry.transform((Object)responseDto, JsonObject.class).orElseThrow(f -> new EdcException("Error creating response body: " + f.getFailureDetail()));
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public void deleteContractDefinition(@PathParam(value="id") String id) {
        this.service.delete(id).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, (String)id));
    }

    @Override
    @PUT
    public void updateContractDefinition(JsonObject updateObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ContractDefinition", updateObject).orElseThrow(ValidationFailureException::new);
        ContractDefinition contractDefinition = (ContractDefinition)this.transformerRegistry.transform((Object)updateObject, ContractDefinition.class).orElseThrow(InvalidRequestException::new);
        this.service.update(contractDefinition).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class));
    }
}

