/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition.transform;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractDefinitionTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractDefinition> {
    public JsonObjectToContractDefinitionTransformer() {
        super(JsonObject.class, ContractDefinition.class);
    }

    @Nullable
    public ContractDefinition transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        ContractDefinition.Builder builder = ContractDefinition.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)object));
        this.visitProperties(object, (key, value) -> {
            switch (key) {
                case "https://w3id.org/edc/v0.0.1/ns/accessPolicyId": {
                    builder.accessPolicyId(this.transformString((JsonValue)value, context));
                    break;
                }
                case "https://w3id.org/edc/v0.0.1/ns/contractPolicyId": {
                    builder.contractPolicyId(this.transformString((JsonValue)value, context));
                    break;
                }
                case "https://w3id.org/edc/v0.0.1/ns/assetsSelector": {
                    builder.assetsSelector(this.transformArray((JsonValue)value, Criterion.class, context));
                    break;
                }
            }
        });
        return (ContractDefinition)this.builderResult(() -> ((ContractDefinition.Builder)builder).build(), context);
    }
}

