/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractdefinition.transform;

import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractDefinitionTransformer
extends AbstractJsonLdTransformer<ContractDefinition, JsonObject> {
    private final TypeManager typeManager;
    private final String typeContext;
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractDefinitionTransformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext) {
        super(ContractDefinition.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractDefinition contractDefinition, @NotNull TransformerContext context) {
        JsonArray criteria = (JsonArray)contractDefinition.getAssetsSelector().stream().map(criterion -> (JsonObject)context.transform(criterion, JsonObject.class)).collect(JsonCollectors.toJsonArray());
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", contractDefinition.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/ContractDefinition").add("https://w3id.org/edc/v0.0.1/ns/accessPolicyId", contractDefinition.getAccessPolicyId()).add("https://w3id.org/edc/v0.0.1/ns/contractPolicyId", contractDefinition.getContractPolicyId()).add("https://w3id.org/edc/v0.0.1/ns/assetsSelector", (JsonValue)criteria);
        if (!contractDefinition.getPrivateProperties().isEmpty()) {
            JsonObjectBuilder privatePropBuilder = this.jsonFactory.createObjectBuilder();
            this.transformProperties(contractDefinition.getPrivateProperties(), privatePropBuilder, this.typeManager.getMapper(this.typeContext), context);
            builder.add("https://w3id.org/edc/v0.0.1/ns/privateProperties", privatePropBuilder);
        }
        return builder.build();
    }
}

