/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractdefinition.v3;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.List;
import org.eclipse.edc.api.model.ApiCoreSchema;

@OpenAPIDefinition(info=@Info(version="v3"))
@Tag(name="Contract Definition V3")
public interface ContractDefinitionApiV3 {
    @Operation(description="Returns all contract definitions according to a query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The contract definitions matching the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ContractDefinitionOutputSchema.class)))}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonArray queryContractDefinitionsV3(JsonObject var1);

    @Operation(description="Gets an contract definition with the given ID", responses={@ApiResponse(responseCode="200", description="The contract definition", content={@Content(schema=@Schema(implementation=ContractDefinitionOutputSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract agreement with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getContractDefinitionV3(String var1);

    @Operation(description="Creates a new contract definition", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ContractDefinitionInputSchema.class))}), responses={@ApiResponse(responseCode="200", description="contract definition was created successfully. Returns the Contract Definition Id and created timestamp", content={@Content(schema=@Schema(implementation=ApiCoreSchema.IdResponseSchema.class))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Could not create contract definition, because a contract definition with that ID already exists", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject createContractDefinitionV3(JsonObject var1);

    @Operation(description="Removes a contract definition with the given ID if possible. DANGER ZONE: Note that deleting contract definitions can have unexpected results, especially for contract offers that have been sent out or ongoing or contract negotiations.", responses={@ApiResponse(responseCode="204", description="Contract definition was deleted successfully"), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A contract definition with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void deleteContractDefinitionV3(String var1);

    @Operation(description="Updated a contract definition with the given ID. The supplied JSON structure must be a valid JSON-LD object", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ContractDefinitionInputSchema.class))}), responses={@ApiResponse(responseCode="204", description="Contract definition was updated successfully"), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A contract definition with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void updateContractDefinitionV3(JsonObject var1);

    @Schema(name="ContractDefinitionOutput", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"definition-id\",\n    \"accessPolicyId\": \"asset-policy-id\",\n    \"contractPolicyId\": \"contract-policy-id\",\n    \"assetsSelector\": [],\n    \"createdAt\": 1688465655\n}\n")
    public record ContractDefinitionOutputSchema(@Schema(name="@id") String id, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractDefinition") String type, String accessPolicyId, String contractPolicyId, List<ApiCoreSchema.CriterionSchema> assetsSelector, long createdAt) {
        public static final String CONTRACT_DEFINITION_OUTPUT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"definition-id\",\n    \"accessPolicyId\": \"asset-policy-id\",\n    \"contractPolicyId\": \"contract-policy-id\",\n    \"assetsSelector\": [],\n    \"createdAt\": 1688465655\n}\n";
    }

    @Schema(name="ContractDefinitionInput", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"definition-id\",\n    \"accessPolicyId\": \"asset-policy-id\",\n    \"contractPolicyId\": \"contract-policy-id\",\n    \"assetsSelector\": []\n}\n")
    public record ContractDefinitionInputSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@id") String id, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/ContractDefinition") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String accessPolicyId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String contractPolicyId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) List<ApiCoreSchema.CriterionSchema> assetsSelector) {
        public static final String CONTRACT_DEFINITION_INPUT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"definition-id\",\n    \"accessPolicyId\": \"asset-policy-id\",\n    \"contractPolicyId\": \"contract-policy-id\",\n    \"assetsSelector\": []\n}\n";
    }
}

