/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractdefinition.transform;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToContractDefinitionTransformer
extends AbstractJsonLdTransformer<JsonObject, ContractDefinition> {
    public JsonObjectToContractDefinitionTransformer() {
        super(JsonObject.class, ContractDefinition.class);
    }

    @Nullable
    public ContractDefinition transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        ContractDefinition.Builder builder = ContractDefinition.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)object));
        this.visitProperties(object, (s, jsonValue) -> this.transformProperties((String)s, (JsonValue)jsonValue, builder, context));
        return (ContractDefinition)this.builderResult(() -> ((ContractDefinition.Builder)builder).build(), context);
    }

    private void transformProperties(String key, JsonValue jsonValue, ContractDefinition.Builder builder, TransformerContext context) {
        switch (key) {
            case "https://w3id.org/edc/v0.0.1/ns/accessPolicyId": {
                builder.accessPolicyId(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/contractPolicyId": {
                builder.contractPolicyId(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/assetsSelector": {
                builder.assetsSelector(this.transformArray(jsonValue, Criterion.class, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/privateProperties": {
                JsonObject props = jsonValue.asJsonArray().getJsonObject(0);
                this.visitProperties(props, (k, val) -> this.transformProperties((String)k, (JsonValue)val, builder, context));
                break;
            }
            default: {
                builder.privateProperty(key, this.transformGenericProperty(jsonValue, context));
            }
        }
    }
}

