/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractdefinition;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.controlplane.services.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

public abstract class BaseContractDefinitionApiController {
    protected final TypeTransformerRegistry transformerRegistry;
    protected final ContractDefinitionService service;
    protected final Monitor monitor;
    protected final JsonObjectValidatorRegistry validatorRegistry;

    public BaseContractDefinitionApiController(TypeTransformerRegistry transformerRegistry, ContractDefinitionService service, Monitor monitor, JsonObjectValidatorRegistry validatorRegistry) {
        this.transformerRegistry = transformerRegistry;
        this.service = service;
        this.monitor = monitor;
        this.validatorRegistry = validatorRegistry;
    }

    public JsonArray queryContractDefinitions(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        return (JsonArray)((List)this.service.search(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class))).stream().map(contractDefinition -> this.transformerRegistry.transform(contractDefinition, JsonObject.class)).peek(r -> r.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    public JsonObject getContractDefinition(String id) {
        return Optional.ofNullable(id).map(arg_0 -> ((ContractDefinitionService)this.service).findById(arg_0)).map(it -> this.transformerRegistry.transform(it, JsonObject.class)).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(ContractDefinition.class, id));
    }

    public JsonObject createContractDefinition(JsonObject createObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ContractDefinition", createObject).orElseThrow(ValidationFailureException::new);
        ContractDefinition transform = (ContractDefinition)this.transformerRegistry.transform((Object)createObject, ContractDefinition.class).orElseThrow(InvalidRequestException::new);
        IdResponse responseDto = (IdResponse)this.service.create(transform).map(contractDefinition -> IdResponse.Builder.newInstance().id(contractDefinition.getId()).createdAt(contractDefinition.getCreatedAt()).build()).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class));
        return (JsonObject)this.transformerRegistry.transform((Object)responseDto, JsonObject.class).orElseThrow(f -> new EdcException("Error creating response body: " + f.getFailureDetail()));
    }

    public void deleteContractDefinition(String id) {
        this.service.delete(id).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, (String)id));
    }

    public void updateContractDefinition(JsonObject updateObject) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/ContractDefinition", updateObject).orElseThrow(ValidationFailureException::new);
        ContractDefinition contractDefinition = (ContractDefinition)this.transformerRegistry.transform((Object)updateObject, ContractDefinition.class).orElseThrow(InvalidRequestException::new);
        this.service.update(contractDefinition).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class));
    }
}

