/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition.transform;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.edc.api.transformer.DtoTransformer;
import org.eclipse.edc.connector.api.management.contractdefinition.model.ContractDefinitionRequestDto;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.spi.asset.AssetSelectorExpression;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractDefinitionRequestDtoToContractDefinitionTransformer
implements DtoTransformer<ContractDefinitionRequestDto, ContractDefinition> {
    public Class<ContractDefinitionRequestDto> getInputType() {
        return ContractDefinitionRequestDto.class;
    }

    public Class<ContractDefinition> getOutputType() {
        return ContractDefinition.class;
    }

    @Nullable
    public ContractDefinition transform(@NotNull ContractDefinitionRequestDto object, @NotNull TransformerContext context) {
        List criteria = object.getCriteria().stream().map(it -> (Criterion)context.transform(it, Criterion.class)).collect(Collectors.toList());
        AssetSelectorExpression selectorExpression = AssetSelectorExpression.Builder.newInstance().criteria(criteria).build();
        return ContractDefinition.Builder.newInstance().id(object.getId()).accessPolicyId(object.getAccessPolicyId()).contractPolicyId(object.getContractPolicyId()).selectorExpression(selectorExpression).validity(object.getValidity()).build();
    }
}

