/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.edc.api.model.CriterionDto;

@JsonDeserialize(builder=Builder.class)
public class ContractDefinitionRequestDto {
    private static final long DEFAULT_VALIDITY = TimeUnit.DAYS.toSeconds(365L);
    private String id;
    @NotNull(message="accessPolicyId cannot be null")
    private @NotNull(message="accessPolicyId cannot be null") String accessPolicyId;
    @NotNull(message="contractPolicyId cannot be null")
    private @NotNull(message="contractPolicyId cannot be null") String contractPolicyId;
    @Valid
    @NotNull(message="criteria cannot be null")
    private @Valid @NotNull(message="criteria cannot be null") List<CriterionDto> criteria = new ArrayList<CriterionDto>();
    @Positive(message="validity must be positive")
    private @Positive(message="validity must be positive") long validity = DEFAULT_VALIDITY;

    private ContractDefinitionRequestDto() {
    }

    @AssertTrue(message="id must be either be null or not blank, and it cannot contain the ':' character")
    @JsonIgnore
    public @AssertTrue(message="id must be either be null or not blank, and it cannot contain the ':' character") boolean isIdValid() {
        return Optional.of(this).map(it -> it.id).map(it -> !it.isBlank() && !it.contains(":")).orElse(true);
    }

    public String getAccessPolicyId() {
        return this.accessPolicyId;
    }

    public String getContractPolicyId() {
        return this.contractPolicyId;
    }

    public List<CriterionDto> getCriteria() {
        return this.criteria;
    }

    public long getValidity() {
        return this.validity;
    }

    public String getId() {
        return this.id;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final ContractDefinitionRequestDto dto = new ContractDefinitionRequestDto();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder accessPolicyId(String accessPolicyId) {
            this.dto.accessPolicyId = accessPolicyId;
            return this;
        }

        public Builder contractPolicyId(String contractPolicyId) {
            this.dto.contractPolicyId = contractPolicyId;
            return this;
        }

        public Builder criteria(List<CriterionDto> criteria) {
            this.dto.criteria = criteria;
            return this;
        }

        public Builder validity(long validity) {
            this.dto.validity = validity;
            return this;
        }

        public Builder id(String id) {
            this.dto.id = id;
            return this;
        }

        public ContractDefinitionRequestDto build() {
            return this.dto;
        }
    }
}

