/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition;

import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.api.model.IdResponseDto;
import org.eclipse.edc.api.query.QuerySpecDto;
import org.eclipse.edc.api.transformer.DtoTransformerRegistry;
import org.eclipse.edc.connector.api.management.contractdefinition.ContractDefinitionApi;
import org.eclipse.edc.connector.api.management.contractdefinition.model.ContractDefinitionRequestDto;
import org.eclipse.edc.connector.api.management.contractdefinition.model.ContractDefinitionResponseDto;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.jetbrains.annotations.NotNull;

@Produces(value={"application/json"})
@Path(value="/contractdefinitions")
public class ContractDefinitionApiController
implements ContractDefinitionApi {
    private final Monitor monitor;
    private final ContractDefinitionService service;
    private final DtoTransformerRegistry transformerRegistry;

    public ContractDefinitionApiController(Monitor monitor, ContractDefinitionService service, DtoTransformerRegistry transformerRegistry) {
        this.monitor = monitor;
        this.service = service;
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    @GET
    @Deprecated
    public List<ContractDefinitionResponseDto> getAllContractDefinitions(@Valid @BeanParam QuerySpecDto querySpecDto) {
        return this.queryContractDefinitions(querySpecDto);
    }

    @Override
    @POST
    @Path(value="/request")
    public List<ContractDefinitionResponseDto> queryAllContractDefinitions(QuerySpecDto querySpecDto) {
        return this.queryContractDefinitions(Optional.ofNullable(querySpecDto).orElse(QuerySpecDto.Builder.newInstance().build()));
    }

    @Override
    @GET
    @Path(value="{id}")
    public ContractDefinitionResponseDto getContractDefinition(@PathParam(value="id") String id) {
        this.monitor.debug(String.format("get contract definition with ID %s", id), new Throwable[0]);
        return Optional.of(id).map(arg_0 -> ((ContractDefinitionService)this.service).findById(arg_0)).map(it -> this.transformerRegistry.transform(it, ContractDefinitionResponseDto.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(ContractDefinition.class, id));
    }

    @Override
    @POST
    public IdResponseDto createContractDefinition(@Valid ContractDefinitionRequestDto dto) {
        this.monitor.debug("Create new contract definition", new Throwable[0]);
        Result transformResult = this.transformerRegistry.transform((Object)dto, ContractDefinition.class);
        if (transformResult.failed()) {
            throw new InvalidRequestException(transformResult.getFailureMessages());
        }
        ContractDefinition contractDefinition = (ContractDefinition)transformResult.getContent();
        ContractDefinition resultContent = (ContractDefinition)this.service.create(contractDefinition).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, (String)dto.getId()));
        this.monitor.debug(String.format("Contract definition created %s", resultContent.getId()), new Throwable[0]);
        return (IdResponseDto)((IdResponseDto.Builder)IdResponseDto.Builder.newInstance().id(resultContent.getId()).createdAt(resultContent.getCreatedAt())).build();
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public void deleteContractDefinition(@PathParam(value="id") String id) {
        this.monitor.debug(String.format("Attempting to delete contract definition with id %s", id), new Throwable[0]);
        ContractDefinition result = (ContractDefinition)this.service.delete(id).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, (String)id));
        this.monitor.debug(String.format("Contract definition deleted %s", result.getId()), new Throwable[0]);
    }

    @NotNull
    private List<ContractDefinitionResponseDto> queryContractDefinitions(QuerySpecDto querySpecDto) {
        Result result = this.transformerRegistry.transform((Object)querySpecDto, QuerySpec.class);
        if (result.failed()) {
            throw new InvalidRequestException(result.getFailureMessages());
        }
        QuerySpec spec = (QuerySpec)result.getContent();
        this.monitor.debug(String.format("get all contract definitions %s", spec), new Throwable[0]);
        try (Stream stream = (Stream)this.service.query(spec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, null));){
            List<ContractDefinitionResponseDto> list = stream.map(it -> this.transformerRegistry.transform(it, ContractDefinitionResponseDto.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(Collectors.toList());
            return list;
        }
    }
}

