/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractdefinition;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.eclipse.edc.api.model.IdResponseDto;
import org.eclipse.edc.api.query.QuerySpecDto;
import org.eclipse.edc.connector.api.management.contractdefinition.model.ContractDefinitionRequestDto;
import org.eclipse.edc.connector.api.management.contractdefinition.model.ContractDefinitionResponseDto;
import org.eclipse.edc.web.spi.ApiErrorDetail;

@OpenAPIDefinition
@Tag(name="Contract Definition")
public interface ContractDefinitionApi {
    @Operation(description="Returns all contract definitions according to a query", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ContractDefinitionResponseDto.class)))}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})}, deprecated=true)
    @Deprecated
    public List<ContractDefinitionResponseDto> getAllContractDefinitions(@Valid QuerySpecDto var1);

    @Operation(description="Returns all contract definitions according to a query", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ContractDefinitionResponseDto.class)))}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public List<ContractDefinitionResponseDto> queryAllContractDefinitions(@Valid QuerySpecDto var1);

    @Operation(description="Gets an contract definition with the given ID", responses={@ApiResponse(responseCode="200", description="The contract definition", content={@Content(schema=@Schema(implementation=ContractDefinitionResponseDto.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="An contract agreement with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public ContractDefinitionResponseDto getContractDefinition(String var1);

    @Operation(description="Creates a new contract definition", responses={@ApiResponse(responseCode="200", description="contract definition was created successfully. Returns the Contract Definition Id and created timestamp", content={@Content(schema=@Schema(implementation=IdResponseDto.class))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="409", description="Could not create contract definition, because a contract definition with that ID already exists", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public IdResponseDto createContractDefinition(@Valid ContractDefinitionRequestDto var1);

    @Operation(description="Removes a contract definition with the given ID if possible. DANGER ZONE: Note that deleting contract definitions can have unexpected results, especially for contract offers that have been sent out or ongoing or contract negotiations.", responses={@ApiResponse(responseCode="200", description="Contract definition was deleted successfully"), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))}), @ApiResponse(responseCode="404", description="A contract definition with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)))})})
    public void deleteContractDefinition(String var1);
}

