/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractagreement;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.connector.controlplane.api.management.contractagreement.ContractAgreementApi;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.controlplane.services.spi.contractagreement.ContractAgreementService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v2/contractagreements")
public class ContractAgreementApiController
implements ContractAgreementApi {
    private final ContractAgreementService service;
    private final TypeTransformerRegistry transformerRegistry;
    private final Monitor monitor;
    private final JsonObjectValidatorRegistry validatorRegistry;

    public ContractAgreementApiController(ContractAgreementService service, TypeTransformerRegistry transformerRegistry, Monitor monitor, JsonObjectValidatorRegistry validatorRegistry) {
        this.service = service;
        this.transformerRegistry = transformerRegistry;
        this.monitor = monitor;
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    @POST
    @Path(value="/request")
    public JsonArray queryAgreements(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        return (JsonArray)((List)this.service.search(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, null))).stream().map(it -> this.transformerRegistry.transform(it, JsonObject.class)).peek(r -> r.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    @Override
    @GET
    @Path(value="{id}")
    public JsonObject getAgreementById(@PathParam(value="id") String id) {
        return Optional.of(id).map(arg_0 -> ((ContractAgreementService)this.service).findById(arg_0)).map(it -> (JsonObject)this.transformerRegistry.transform(it, JsonObject.class).orElseThrow(failure -> new EdcException(failure.getFailureDetail()))).orElseThrow(() -> new ObjectNotFoundException(ContractAgreement.class, id));
    }

    @Override
    @GET
    @Path(value="{id}/negotiation")
    public JsonObject getNegotiationByAgreementId(@PathParam(value="id") String id) {
        return Optional.of(id).map(arg_0 -> ((ContractAgreementService)this.service).findNegotiation(arg_0)).map(it -> (JsonObject)this.transformerRegistry.transform(it, JsonObject.class).orElseThrow(failure -> new EdcException(failure.getFailureDetail()))).orElseThrow(() -> new ObjectNotFoundException(ContractAgreement.class, id));
    }
}

