/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractagreement;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import org.eclipse.edc.api.model.ApiCoreSchema;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiSchema;

@OpenAPIDefinition
@Tag(name="Contract Agreement")
public interface ContractAgreementApi {
    @Operation(description="Gets all contract agreements according to a particular query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The contract agreements matching the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ManagementApiSchema.ContractAgreementSchema.class)))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonArray queryAllAgreements(JsonObject var1);

    @Operation(description="Gets an contract agreement with the given ID", responses={@ApiResponse(responseCode="200", description="The contract agreement", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractAgreementSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract agreement with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getAgreementById(String var1);

    @Operation(description="Gets a contract negotiation with the given contract agreement ID", responses={@ApiResponse(responseCode="200", description="The contract negotiation", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractNegotiationSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract agreement with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getNegotiationByAgreementId(String var1);
}

