/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.contractagreement.v3;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import org.eclipse.edc.api.management.schema.ManagementApiSchema;
import org.eclipse.edc.api.model.ApiCoreSchema;

@OpenAPIDefinition(info=@Info(version="v3"))
@Tag(name="Contract Agreement V3")
public interface ContractAgreementApiV3 {
    @Operation(description="Gets all contract agreements according to a particular query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The contract agreements matching the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ManagementApiSchema.ContractAgreementSchema.class)))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonArray queryAgreementsV3(JsonObject var1);

    @Operation(description="Gets an contract agreement with the given ID", responses={@ApiResponse(responseCode="200", description="The contract agreement", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractAgreementSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract agreement with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getAgreementByIdV3(String var1);

    @Operation(description="Gets a contract negotiation with the given contract agreement ID", responses={@ApiResponse(responseCode="200", description="The contract negotiation", content={@Content(schema=@Schema(implementation=ManagementApiSchema.ContractNegotiationSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An contract agreement with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getNegotiationByAgreementIdV3(String var1);
}

