/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractagreement.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import org.eclipse.edc.policy.model.Policy;

public class ContractAgreementDto {
    @NotNull(message="id cannot be null")
    private @NotNull(message="id cannot be null") String id;
    @NotNull(message="providerAgentId cannot be null")
    private @NotNull(message="providerAgentId cannot be null") String providerAgentId;
    @NotNull(message="consumerAgentId cannot be null")
    private @NotNull(message="consumerAgentId cannot be null") String consumerAgentId;
    @Positive(message="contractSigningDate must be greater than 0")
    private @Positive(message="contractSigningDate must be greater than 0") long contractSigningDate;
    @Positive(message="contractStartDate must be greater than 0")
    private @Positive(message="contractStartDate must be greater than 0") long contractStartDate;
    @Positive(message="contractEndDate must be greater than 0")
    private @Positive(message="contractEndDate must be greater than 0") long contractEndDate;
    @NotNull(message="assetId Id cannot be null")
    private @NotNull(message="assetId Id cannot be null") String assetId;
    @NotNull(message="policy cannot be null")
    private @NotNull(message="policy cannot be null") Policy policy;

    @AssertTrue(message="contractStartDate and contractSigningDate must be lower than contractEndDate")
    @JsonIgnore
    public @AssertTrue(message="contractStartDate and contractSigningDate must be lower than contractEndDate") boolean isDatesValid() {
        return this.contractStartDate < this.contractEndDate && this.contractSigningDate < this.contractEndDate;
    }

    public String getId() {
        return this.id;
    }

    public String getProviderAgentId() {
        return this.providerAgentId;
    }

    public String getConsumerAgentId() {
        return this.consumerAgentId;
    }

    public long getContractSigningDate() {
        return this.contractSigningDate;
    }

    public long getContractStartDate() {
        return this.contractStartDate;
    }

    public long getContractEndDate() {
        return this.contractEndDate;
    }

    public String getAssetId() {
        return this.assetId;
    }

    @NotNull
    public Policy getPolicy() {
        return this.policy;
    }

    public static final class Builder {
        private final ContractAgreementDto agreement = new ContractAgreementDto();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.agreement.id = id;
            return this;
        }

        public Builder providerAgentId(String providerAgentId) {
            this.agreement.providerAgentId = providerAgentId;
            return this;
        }

        public Builder consumerAgentId(String consumerAgentId) {
            this.agreement.consumerAgentId = consumerAgentId;
            return this;
        }

        public Builder contractSigningDate(long contractSigningDate) {
            this.agreement.contractSigningDate = contractSigningDate;
            return this;
        }

        public Builder contractStartDate(long contractStartDate) {
            this.agreement.contractStartDate = contractStartDate;
            return this;
        }

        public Builder contractEndDate(long contractEndDate) {
            this.agreement.contractEndDate = contractEndDate;
            return this;
        }

        public Builder assetId(String assetId) {
            this.agreement.assetId = assetId;
            return this;
        }

        public Builder policy(Policy policy) {
            this.agreement.policy = policy;
            return this;
        }

        public ContractAgreementDto build() {
            return this.agreement;
        }
    }
}

