/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.contractagreement;

import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.api.query.QuerySpecDto;
import org.eclipse.edc.api.transformer.DtoTransformerRegistry;
import org.eclipse.edc.connector.api.management.contractagreement.ContractAgreementApi;
import org.eclipse.edc.connector.api.management.contractagreement.model.ContractAgreementDto;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.spi.contractagreement.ContractAgreementService;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.jetbrains.annotations.NotNull;

@Produces(value={"application/json"})
@Path(value="/contractagreements")
public class ContractAgreementApiController
implements ContractAgreementApi {
    private final Monitor monitor;
    private final ContractAgreementService service;
    private final DtoTransformerRegistry transformerRegistry;

    public ContractAgreementApiController(Monitor monitor, ContractAgreementService service, DtoTransformerRegistry transformerRegistry) {
        this.monitor = monitor;
        this.service = service;
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    @GET
    @Deprecated
    public List<ContractAgreementDto> getAllAgreements(@Valid @BeanParam QuerySpecDto querySpecDto) {
        return this.queryContractAgreements(querySpecDto);
    }

    @Override
    @POST
    @Path(value="/request")
    public List<ContractAgreementDto> queryAllAgreements(@Valid QuerySpecDto querySpecDto) {
        return this.queryContractAgreements(Optional.ofNullable(querySpecDto).orElse(QuerySpecDto.Builder.newInstance().build()));
    }

    @Override
    @GET
    @Path(value="{id}")
    public ContractAgreementDto getContractAgreement(@PathParam(value="id") String id) {
        this.monitor.debug(String.format("get contract agreement with ID %s", id), new Throwable[0]);
        return Optional.of(id).map(arg_0 -> ((ContractAgreementService)this.service).findById(arg_0)).map(it -> this.transformerRegistry.transform(it, ContractAgreementDto.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(ContractAgreement.class, id));
    }

    @NotNull
    private List<ContractAgreementDto> queryContractAgreements(QuerySpecDto querySpecDto) {
        Result result = this.transformerRegistry.transform((Object)querySpecDto, QuerySpec.class);
        if (result.failed()) {
            throw new InvalidRequestException(result.getFailureMessages());
        }
        QuerySpec spec = (QuerySpec)result.getContent();
        this.monitor.debug(String.format("get all contract agreements from %s", spec), new Throwable[0]);
        try (Stream stream = (Stream)this.service.query(spec).orElseThrow(ServiceResultHandler.exceptionMapper(ContractDefinition.class, null));){
            List<ContractAgreementDto> list = stream.map(it -> this.transformerRegistry.transform(it, ContractAgreementDto.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(Collectors.toList());
            return list;
        }
    }
}

