/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.configuration.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ConfigurationExtension;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.spi.system.configuration.ConfigFactory;
import org.eclipse.edc.util.configuration.ConfigurationFunctions;

@Extension(value="FS Configuration")
public class FsConfigurationExtension
implements ConfigurationExtension {
    public static final String NAME = "FS Configuration";
    @Setting
    private static final String FS_CONFIG = "edc.fs.config";
    private Config config;
    private Path configFile;

    public FsConfigurationExtension() {
    }

    FsConfigurationExtension(Path configFile) {
        this.configFile = configFile;
    }

    public String name() {
        return NAME;
    }

    public void initialize(Monitor monitor) {
        Path configPath;
        String configLocation = ConfigurationFunctions.propOrEnv((String)FS_CONFIG, (String)"dataspaceconnector-configuration.properties");
        Path path = configPath = this.configFile != null ? this.configFile : Paths.get(configLocation, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            monitor.warning(String.format("Configuration file does not exist: %s. Ignoring.", configLocation), new Throwable[0]);
            return;
        }
        try (InputStream is = Files.newInputStream(configPath, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(is);
            this.config = ConfigFactory.fromProperties((Properties)properties);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public Config getConfig() {
        return this.config;
    }
}

